﻿using UnityEngine;
using System.Collections;

[RequireComponent(typeof(BoxCollider))]
public class InteractTrigger : MonoBehaviour
{
    private bool m_IsIn;
    public bool IsIn
    {
        get { return m_IsIn; }
    }

    private Character m_Character;
    public Character InteractCharacter
    {
        get { return m_Character; }
    }

    void OnEnable()
    {
        m_IsIn = false;
    }

    void OnDisable()
    {
        m_IsIn = false;
    }

    void OnTriggerEnter(Collider obj)
    {
        if (m_IsIn)
            return;

        if (obj.name == "VirusModel")
        {
            //Debug.Log("Virus is in");
            m_IsIn = true;
            m_Character = obj.transform.parent.GetComponent<Character>();
        }
    }

    void OnTriggerExit(Collider obj)
    {
        if (!m_IsIn)
            return;

        if (obj.name == "VirusModel")
        {
            //Debug.Log("Virus is out");
            m_IsIn = false;
        }
    }
}