﻿using UnityEngine;
using System.Collections;

public class Element : MonoBehaviour
{
    protected bool m_Active;
    public bool IsActive
    {
        get { return m_Active; }
    }

    protected virtual void OnEnable()
    {
        m_Active = true;
    }

    protected virtual void Start()
    {
	}

    public virtual bool UpdateElement()
    {
        return false;
    }

    public virtual void Show()
    {
        m_Active = true;
        renderer.enabled = true;
    }

    public virtual void Hide()
    {
        m_Active = false;
        renderer.enabled = false;
    }

    public virtual void SaveStatus()
    {
    }

    public virtual void ReInit()
    {
    }
}