﻿using UnityEngine;
using System.Collections;

public class CollectibleElement : Element
{
    protected bool m_Collected;
    protected InteractTrigger m_Trigger;

    protected override void Start()
    {
        base.Start();
        m_Trigger = GetComponentInChildren<InteractTrigger>();
    }

    public override bool UpdateElement()
    {
        if (m_Trigger.IsIn)
        {
            TakeIt();
        }
        return base.UpdateElement();
    }

    public override void SaveStatus()
    {
        if (!gameObject.activeSelf) m_Collected = true;
    }

    public override void ReInit()
    {
        if (!m_Collected)
        {
            gameObject.SetActive(true);
        }
    }

    protected virtual void TakeIt()
    {
        gameObject.SetActive(false);
    }
}