﻿using UnityEngine;
using System.Collections;

public class Brick : MonoBehaviour 
{
    public AnimationCurve m_LightingCurve;

	void Start()
    {
        renderer.material.color = Color.black;
	}

    public void Illumin()
    {
        if (renderer.isVisible)
        {
            StartCoroutine(C_Illumin(Random.Range(0.5f, 2f), Random.Range(0.5f, 2f)));
        }
        else
        {
            renderer.material.color = Color.white;
        }
    }

    private IEnumerator C_Illumin(float tmp, float speed)
    {
        yield return new WaitForSeconds(tmp);

        float timer = 0f;

        while (timer < 1f)
        {
            renderer.material.color = Color.Lerp(Color.black, Color.white, m_LightingCurve.Evaluate(timer));
            timer += Time.deltaTime * speed;
            yield return 0;
        }

        renderer.material.color = Color.white;
    }

    public void Alert()
    {
        if (renderer.isVisible)
        {
            renderer.material.color = Color.red;
        }
    }

    public void ReInit()
    {
        renderer.material.color = Color.white;
    }
}