using UnityEngine;
using System.Collections;

public class Hero_Interaction
{
    // General
    private bool m_CanUseSomething;
    private InteractiveElement m_Element;
    private bool m_UseSomething;
    public bool UseSomething
    {
        get { return m_UseSomething; }
    }

    // Hide
    private bool m_Hidden;
    public bool Hidden
    {
        get { return m_Hidden; }
    }
    private bool m_CanHide;
    public bool CanHide
    {
        get { return m_CanHide; }
    }

	public Hero_Interaction()
	{
        m_Hidden = false;
	}

    public void HeroCanUseSomething(bool can, InteractiveElement element)
    {
        m_CanUseSomething = can;

        if (can)
        {
            m_Element = element;
        }
        switch (m_Element.InteractionType)
        {
            case ElementSettings.InteractionType.Hide:
                m_CanHide = can;
                break;
        }
        if (!can)
        {
            m_Element = element;
        }
    }

    public void Interact()
    {
        switch (m_Element.InteractionType)
        {
            case ElementSettings.InteractionType.Hide:
                m_Element.UseIt();
                m_Hidden = !m_Hidden;
                m_CanHide = !m_Hidden;
                break;
        }
    }
}