using UnityEngine;
using System.Collections;

public class Hero_Animator : Character_Animator
{
    protected override void Start()
    {
        m_Animator = GetComponentInChildren<Animator>();
        if (m_Animator == null)
        {
            Debug.LogWarning("No Animator component is attached");
        }
    }

    public override void SetSpeed(float speed)
    {
        if (m_Animator) m_Animator.SetFloat("Speed", speed);
    }

    public override float PlayIdle()
    {
        return 0f;
    }
}