﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class EnemyRoutine : MonoBehaviour
{
    // Enable
    private bool m_Enable;

    // Enemy transform
    private Transform m_Transform;

    // Translation
    public bool m_Translate;
    public bool Translate
    {
        get { return m_Translate; }
        set { m_Translate = value; }
    }
    public List<Vector3> Translations;
    public List<float> TranslationSpeeds;
    public List<bool> TranslationPauses;
    private Vector3[] m_Translations;
    private float[] m_TranslationSpeeds;
    private Vector3 m_BeginPos;
    private Vector3 m_EndPos;
    private int m_CurrentTranslation;
    private Timer m_TranslationTimer;
    // Rotation
    public bool m_Rotate;
    public bool Rotate
    {
        get { return m_Rotate; }
        set { m_Rotate = value; }
    }
    public List<Vector3> Rotations;
    public List<float> RotationSpeeds;
    private Quaternion[] m_Rotations;
    private float[] m_RotationSpeeds;
    private int m_CurrentRotation;
    private Timer m_RotationTimer;

	void Start()
    {
        m_Enable = true;
        m_Transform = transform;

        // Translations
        if (m_Translate)
        {
            if (Translations != null && Translations.Count > 0)
            {
                m_Translations = Translations.ToArray();
                m_TranslationSpeeds = TranslationSpeeds.ToArray();
                m_CurrentTranslation = 0;
                m_TranslationTimer = new Timer();
                SetTranslation();
            }
            else m_Translate = false;
        }

        // Rotation
        if (m_Rotate)
        {
            if (Rotations != null && Rotations.Count > 0)
            {
                for (int i = 0; i < Rotations.Count; ++i)
                {
                    m_Rotations[i] = Quaternion.Euler(Rotations[i]);
                }
                m_RotationSpeeds = RotationSpeeds.ToArray();
                m_CurrentRotation = 0;
                m_RotationTimer = new Timer(m_RotationSpeeds[0]);
                m_RotationTimer.Start();
            }
            else m_Rotate = false;
        }
	}

    void Update()
    {
        if (!m_Enable)
            return;

        // Movements
        // => Translation
        if (!m_TranslationTimer.UpdateTime())
        {
            if (!TranslationPauses[m_CurrentTranslation]) m_Transform.position = Vector3.Lerp(m_BeginPos, m_EndPos, m_TranslationTimer.GetHermiteProgress());
        }
        else
        {
            m_CurrentTranslation = (m_CurrentTranslation + 1) % m_Translations.Length;
            SetTranslation();
        }

        // TODO : => Translation
    }

    private void SetTranslation()
    {
        if (!TranslationPauses[m_CurrentTranslation])
        {
            m_BeginPos = m_Transform.position;
            m_EndPos = m_BeginPos + m_Translations[m_CurrentTranslation];
        }

        m_TranslationTimer.Restart(m_TranslationSpeeds[m_CurrentTranslation]);
    }

    private void SetRotation()
    {
        // TODO
    }

    public void SetEnable(bool enable)
    {
        m_Enable = enable;
    }
}