using UnityEngine;
using System.Collections;

public class Character : MonoBehaviour
{
	protected CharacterSettings.Type m_Type;
	public CharacterSettings.Type Type
	{
		get { return m_Type; }
	}
	public bool IsHero
	{
		get { return (m_Type == CharacterSettings.Type.Hero); }
	}
	
	// Manager and character transforms
	protected Transform m_Transform;
	public Transform m_CharacterModel;
	
	// Character motor
	protected Character_Motor m_CharacterMotor;
	
	// Character animator
	protected Character_Animator m_CharacterAnimator;
	public Character_Animator CharacterAnimator
	{
		get { return m_CharacterAnimator; }
	}
	
	// Character physic
	protected Character_Physic m_CharacterPhysic;
	
	// Spawn offset
	protected Vector3 m_SpawnOffset;

	protected virtual void Start()
	{
		m_Transform = transform;
	}
	
	// Update is called once per frame
	public virtual void UpdateCharacter()
	{
	}

    #region Events
    public virtual void ReInit()
    {
    }

    public virtual void Spawn(Vector3 position)
	{
		m_Transform.position = position + m_SpawnOffset;
		m_CharacterModel.localPosition = Vector3.zero;
		m_CharacterModel.localRotation = Quaternion.identity;
    }

    public virtual void CharacterCanMove(bool can)
    {
    }

    public virtual void CharacterOnPlatform(bool isOn, bool canMove, Platform platform)
    {
        m_CharacterMotor.IsOnPlatform(isOn, canMove, platform);
    }

    public virtual void CharacterCanUseSomething(bool can, InteractiveElement element)
    {
    }

    public virtual void MustGoSomewhere(Vector3 position, float duration)
    {
        m_CharacterMotor.MustGoSomewhere(position, duration);
    }
    #endregion
}