﻿using UnityEditor;
using UnityEngine;
using System.Collections;
using System.Collections.Generic;

[CustomEditor(typeof(EnemyRoutine))]
public class EnemyRoutineInspector : Editor
{
    public override void OnInspectorGUI()
    {
        EnemyRoutine myTarget = (EnemyRoutine)target;
        // Get translations informations
        List<Vector3> translations = myTarget.Translations;
        List<float> translationSpeeds = myTarget.TranslationSpeeds;
        List<bool> translationPauses = myTarget.TranslationPauses;
        // Get rotations informations
        List<Vector3> rotations = myTarget.Rotations;
        List<float> rotationSpeeds = myTarget.RotationSpeeds;

#region Translations
        // Display tranlations informations
        myTarget.Translate = GUILayout.Toggle(myTarget.Translate, "Translate");
        if (myTarget.Translate)
        {
            if (translations != null && translations.Count > 0)
            {
                Vector3 tmp;
                for (int i = 0; i < translations.Count; ++i)
                {
                    tmp = translations[i];
                    EditorGUILayout.BeginHorizontal();
                    {
                        EditorGUILayout.LabelField("Translation " + (i + 1));
                        translationPauses[i] = GUILayout.Toggle(translationPauses[i], "Is pause");
                        if (GUILayout.Button("Del"))
                        {
                            translations.RemoveAt(i);
                            translationSpeeds.RemoveAt(i);
                            translationPauses.RemoveAt(i);
                            break;
                        }
                    }
                    EditorGUILayout.EndHorizontal();

                    if(!translationPauses[i])
                    {
                        EditorGUILayout.LabelField(" => Move : ");
                        EditorGUILayout.BeginHorizontal();
                        {
                            GUILayout.Label("x");
                            tmp.x = EditorGUILayout.FloatField(tmp.x);
                            GUILayout.Label("y");
                            tmp.y = EditorGUILayout.FloatField(tmp.y);
                            GUILayout.Label("z");
                            tmp.z = EditorGUILayout.FloatField(tmp.z);
                        }
                        EditorGUILayout.EndHorizontal();
                    }

                    EditorGUILayout.BeginHorizontal();
                    {
                        GUILayout.Label(" => Duration : ");
                        translationSpeeds[i] = EditorGUILayout.FloatField(translationSpeeds[i]);
                    }
                    EditorGUILayout.EndHorizontal();

                    translations[i] = tmp;
                }
            }

            EditorGUILayout.BeginHorizontal();
            {
                // Button for creating new translation
                if (GUILayout.Button("Add translation"))
                {
                    if (translations == null)
                    {
                        translations = new List<Vector3>();
                        translationSpeeds = new List<float>();
                        translationPauses = new List<bool>();
                    }
                    translations.Add(new Vector3());
                    translationSpeeds.Add(1f);
                    translationPauses.Add(false);
                }
            }
            EditorGUILayout.EndHorizontal();
        }
#endregion

#region Rotations
        // Display rotations informations
        myTarget.Rotate = GUILayout.Toggle(myTarget.Rotate, "Rotate");
        if (myTarget.Rotate)
        {
            if (rotations != null && rotations.Count > 0)
            {
                Vector3 tmp;
                for (int i = 0; i < rotations.Count; ++i)
                {
                    tmp = rotations[i];
                    EditorGUILayout.BeginHorizontal();
                    {
                        EditorGUILayout.LabelField("Rotation " + (i + 1));
                        if (GUILayout.Button("Del"))
                        {
                            rotations.RemoveAt(i);
                            rotationSpeeds.RemoveAt(i);
                            break;
                        }
                    }
                    EditorGUILayout.EndHorizontal();

                    EditorGUILayout.LabelField(" => Move : ");
                    EditorGUILayout.BeginHorizontal();
                    {
                        GUILayout.Label("x");
                        tmp.x = EditorGUILayout.FloatField(tmp.x);
                        GUILayout.Label("y");
                        tmp.y = EditorGUILayout.FloatField(tmp.y);
                        GUILayout.Label("z");
                        tmp.z = EditorGUILayout.FloatField(tmp.z);
                    }
                    EditorGUILayout.EndHorizontal();

                    EditorGUILayout.BeginHorizontal();
                    {
                        GUILayout.Label(" => Duration : ");
                        rotationSpeeds[i] = EditorGUILayout.FloatField(rotationSpeeds[i]);
                    }
                    EditorGUILayout.EndHorizontal();

                    rotations[i] = tmp;
                }
            }

            // Button for creating new rotation
            if (GUILayout.Button("Add rotation"))
            {
                if (rotations == null)
                {
                    rotations = new List<Vector3>();
                    rotationSpeeds = new List<float>();
                }
                rotations.Add(new Vector3());
                rotationSpeeds.Add(1f);
            }
        }
#endregion

        // Apply changement
        if (GUI.changed)
        {
            myTarget.Translations = translations;
            myTarget.TranslationSpeeds = translationSpeeds;
            myTarget.Rotations = rotations;
            myTarget.RotationSpeeds = rotationSpeeds;
            EditorUtility.SetDirty(myTarget);
        }
    }
}