using UnityEditor;
using UnityEngine;
using System.Collections.Generic;

[CustomEditor(typeof(CameraMovements))]
public class CameraMovementsEditor : Editor
{
	public override void OnInspectorGUI()
    {
        CameraMovements myTarget = (CameraMovements)target;
        List<MovableCameraZone> moveZones = myTarget.MovableZones;
        List<FixedCameraZone> fixZones = myTarget.FixedZones;

        // Display zones informations
        int i = 1;
        if (moveZones != null && moveZones.Count > 0)
        {
            EditorGUILayout.HelpBox("Movable zones", MessageType.None);
            // Movable zones
            foreach (MovableCameraZone moveZone in moveZones)
            {
                EditorGUILayout.BeginHorizontal();
                {
                    EditorGUILayout.LabelField("Zone " + i);
                    if (GUILayout.Button("Del"))
                    {
                        moveZones.Remove(moveZone);
                        break;
                    }
                }
                EditorGUILayout.EndHorizontal();

                EditorGUILayout.LabelField("=> Character zone : ");
                EditorGUILayout.BeginHorizontal();
                {
                    GUILayout.Label("xMin");
                    moveZone.CharacterZone.xMin = EditorGUILayout.FloatField(moveZone.CharacterZone.xMin);
                    GUILayout.Label("xMax");
                    moveZone.CharacterZone.xMax = EditorGUILayout.FloatField(moveZone.CharacterZone.xMax);
                    GUILayout.Label("yMin");
                    moveZone.CharacterZone.yMin = EditorGUILayout.FloatField(moveZone.CharacterZone.yMin);
                    GUILayout.Label("yMax");
                    moveZone.CharacterZone.yMax = EditorGUILayout.FloatField(moveZone.CharacterZone.yMax);
                }
                EditorGUILayout.EndHorizontal();

                EditorGUILayout.LabelField("=> Camera zone : ");
                EditorGUILayout.BeginHorizontal();
                {
                    GUILayout.Label("xMin");
                    moveZone.CameraZone.xMin = EditorGUILayout.FloatField(moveZone.CameraZone.xMin);
                    GUILayout.Label("xMax");
                    moveZone.CameraZone.xMax = EditorGUILayout.FloatField(moveZone.CameraZone.xMax);
                    GUILayout.Label("yMin");
                    moveZone.CameraZone.yMin = EditorGUILayout.FloatField(moveZone.CameraZone.yMin);
                    GUILayout.Label("zMax");
                    moveZone.CameraZone.yMax = EditorGUILayout.FloatField(moveZone.CameraZone.yMax);
                }
                EditorGUILayout.EndHorizontal();

                EditorGUILayout.BeginHorizontal();
                {
                    GUILayout.Label("Distance");
                    moveZone.Distance = Mathf.Abs(EditorGUILayout.FloatField(moveZone.Distance));
                }
                EditorGUILayout.EndHorizontal();

                EditorGUILayout.BeginHorizontal();
                {
                    moveZone.LockX = GUILayout.Toggle(moveZone.LockX, "Lock X axe");
                    if (moveZone.LockX)
                    {
                        moveZone.ValueX = EditorGUILayout.FloatField(moveZone.ValueX);
                    }
                }
                EditorGUILayout.EndHorizontal();

                EditorGUILayout.BeginHorizontal();
                {
                    moveZone.LockY = GUILayout.Toggle(moveZone.LockY, "Lock Y axe");
                    if (moveZone.LockY)
                    {
                        moveZone.ValueY = EditorGUILayout.FloatField(moveZone.ValueY);
                    }
                }
                EditorGUILayout.EndHorizontal();

                if (moveZone.LockX && moveZone.LockY)
                {
                    EditorGUILayout.HelpBox("Creating a fix zone intead of this one must be a better idea", MessageType.Warning);
                }

                // Tests for character zone
                if (moveZone.CharacterZone.xMax < moveZone.CharacterZone.xMin) moveZone.CharacterZone.xMax = moveZone.CharacterZone.xMin;
                if (moveZone.CharacterZone.yMax < moveZone.CharacterZone.yMin) moveZone.CharacterZone.yMax = moveZone.CharacterZone.yMin;

                ++i;
                GUILayout.Box("", GUILayout.ExpandWidth(true), GUILayout.Height(2));
            }

            EditorGUILayout.Separator();
        }

        if (fixZones != null && fixZones.Count > 0)
        {
            EditorGUILayout.HelpBox("Fixed zones", MessageType.None);
            // Fixed zones
            foreach (FixedCameraZone fixZone in fixZones)
            {
                EditorGUILayout.BeginHorizontal();
                {
                    EditorGUILayout.LabelField("Zone " + i);
                    if (GUILayout.Button("Del"))
                    {
                        fixZones.Remove(fixZone);
                        break;
                    }
                }
                EditorGUILayout.EndHorizontal();

                EditorGUILayout.LabelField("=> Character zone : ");
                EditorGUILayout.BeginHorizontal();
                {
                    GUILayout.Label("xMin");
                    fixZone.CharacterZone.xMin = EditorGUILayout.FloatField(fixZone.CharacterZone.xMin);
                    GUILayout.Label("xMax");
                    fixZone.CharacterZone.xMax = EditorGUILayout.FloatField(fixZone.CharacterZone.xMax);
                    GUILayout.Label("yMin");
                    fixZone.CharacterZone.yMin = EditorGUILayout.FloatField(fixZone.CharacterZone.yMin);
                    GUILayout.Label("yMax");
                    fixZone.CharacterZone.yMax = EditorGUILayout.FloatField(fixZone.CharacterZone.yMax);
                }
                EditorGUILayout.EndHorizontal();

                EditorGUILayout.BeginHorizontal();
                {
                    GUILayout.Label("=> Camera zone : ");
                    fixZone.CameraZone = EditorGUILayout.ObjectField(fixZone.CameraZone, typeof(Transform)) as Transform;
                }
                EditorGUILayout.EndHorizontal();

                // Tests for character zone
                if (fixZone.CharacterZone.xMax < fixZone.CharacterZone.xMin) fixZone.CharacterZone.xMax = fixZone.CharacterZone.xMin;
                if (fixZone.CharacterZone.yMax < fixZone.CharacterZone.yMin) fixZone.CharacterZone.yMax = fixZone.CharacterZone.yMin;

                ++i;
                GUILayout.Box("", GUILayout.ExpandWidth(true), GUILayout.Height(5));
            }

            EditorGUILayout.Separator();
        }

        EditorGUILayout.BeginHorizontal();
        {
            // Button for creating new movable zone
            if (GUILayout.Button("Add movable zone"))
            {
                if (moveZones == null)
                {
                    moveZones = new List<MovableCameraZone>();
                }
                moveZones.Add(new MovableCameraZone(new Vect4f(), new Vect4f()));
            }

            // Button for creating new fixed zone
            if (GUILayout.Button("Add fixed zone"))
            {
                if (fixZones == null)
                {
                    fixZones = new List<FixedCameraZone>();
                }
                fixZones.Add(new FixedCameraZone(new Vect4f()));
            }
        }
        EditorGUILayout.EndHorizontal();

        // Apply changement
        if (GUI.changed)
        {
            myTarget.MovableZones = moveZones;
            myTarget.FixedZones = fixZones;
            EditorUtility.SetDirty(myTarget);
        }
    }
}