﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public enum CAT_TRUFFE_COLOR
{
	PINK,
	DARKPINK, 
	ORANGEPINK,
	ORANGE,
	LIGHTBROWN,
	BROWN,
	DARKGREY, 
	BLACK,

	COUNT,
	INVALID = 1000
}

public enum CAT_EYES_COLOR
{
	LIGHT_GREEN,
	YELLOW,	
	BROWN,		
	DARK_BLUE,
	DARK_GREEN,
	LIGHT_BLUE,

	COUNT,
	INVALID = 1000
}

public enum CAT_COLOR
{
	SNOW_QUEEN,
	SHADOW_STONE,
	GOLDEN_PEACH,
	YELLOW_BANANA,
	COCOA_SPICE,
	GREY_MIST,
	ROXY_ORANGEADE,
	MIDNIGHT_PLUM,
	SPLASH_BLUE,
	SWEET_BLUSH,
	SUNNY_LEMON,
	OCEAN_CYAN,
	TANGY_RED,
	FRESH_LEAF,
	RIPE_BLUE,
	PINK_PULSE,
	LIME_GLOW,
	VIVID_VIOLET,
	SUSPICIOUS_DISH,
	BLACK,

	COUNT,
	INVALID = 1000
}

public enum CAT_SHAPE
{
	NONE,

	RAYURES,    // 01 TRIPOD
	DALMATIEN,  // 02 DONUT
	RIZ,	    // 03 POINT
	LEOPARD,    // 04 SPOT
	GIRAFE,     // 05 DELTA
	VACHE,      // 06 CROSS
	ZEBRE,      // 07 LINE
	SQUARE,     // 08 SQUARE

	COUNT,
	LEGENDARY,
	INVALID
}

public enum CAT_ZONE
{
	NONE,
	ZONE01,
	ZONE02,
	ZONE03,
	ZONE04,
	ZONE05,
	ZONE06,
	ZONE07,
	
	COUNT,
	INVALID
}

public enum CAT_LEGENDARY
{
	NONE,

	CHAMAN,
	KITSUNE,
	MANEKI,
	PATRICK,
	ARCANA,
	UNICRON,
	FEE,
	TANUKI,

	COUNT,
	INVALID = 1000
}

//-------------------------------------------------------------------------------------------------

//[System.Serializable]
/*public struct Skin
{
	public SKIN skinHead;
	public SKIN skinBody;
}*/


//-------------------------------------------------------------------------------------------------

[System.Serializable]
public class Cat : Item
{
	[SerializeField]
	private string _id;

	public string Id
	{
		get
		{
			return _id;
		}
	}

	public Apparence Apparence;

	// Only for legendaries
	public Progress progress = null;

	// Propriétés du chat
	public Properties Properties;

	public CAT_ZONE catZone;
	public TextureSerializable TextureZone = null; // Used if catZone == CUSTOM

	public const double ADULT_AGE = 3600.0; // 1 heure

	public double birth;

	public override string GetDesc() => throw new System.NotImplementedException();
	public override int GetInternalType() => throw new System.NotImplementedException();
	public override string GetName() => throw new System.NotImplementedException();
	public override Sprite GetSprite() => throw new System.NotImplementedException();

	public bool IsLegendary => Apparence.IsLegendary;

	[SerializeField]
	public string name;

	public double Age
	{
		get
		{
			return Data.Time - birth;
		}
	}

	[SerializeField]
	bool locked = false;

	public bool IsLocked
	{
		get
		{
			return locked || Apparence.IsLegendary;
		}
	}


	//------------------------------------------------------------------------------------------------


	public Cat(Apparence apparence, double age = Rabbit.ADULT_AGE)
	{
		_id = System.Guid.NewGuid().ToString("N").Substring(0, 16);

		this.Apparence = apparence;

		Properties.Init();

		if (apparence.IsLegendary)
		{
			//name = Legendary.Instance.GetName(apparence.Color);
			//progress = new Progress(apparence.Color);
		}
		else
		{
			name = Naming.GeneratePronounceableName();
			//progress = null;
		}

		position = new Vector2(Random.Range(0.2f, 0.8f), Random.Range(0.1f, 0.9f));
		//skinScale = new Vector2(Random.Range(4.0f, 6.0f), Random.Range(4.0f, 6.0f));
		//skinOffset = new Vector2(Random.value, Random.value);

		if (apparence.IsLegendary)
		{
			//locked = true;
			//training = new Training();
		}

		Set(age);
	}

	//---------------------------------------------------------------------------------------------

	public void Set(double age)
	{
		birth = Data.Time - age;
	}

	//------------------------------------------------------------------------------------------------
	static public Cat CreateNewLegendary(CAT_COLOR legendaryType, double age = ADULT_AGE)
	{
		if (legendaryType <= CAT_COLOR.COUNT || legendaryType >= (CAT_COLOR)RABBIT_COLOR.SPECIALS_MAX)
		{
			UnityEngine.Debug.LogError("legendaryType out of bound " + legendaryType);
			return null;
		}

		int index = (int)legendaryType - (int)CAT_COLOR.COUNT - 1;

		if (Data.Instance.Legendaries[index] != null)
		{
			return Data.Instance.Legendaries[index];
		}

		Cat rabbit = new Cat(new Apparence(legendaryType), age);

		Data.Instance.Legendaries[index] = rabbit;
		/*



		if (Data.Instance.legendaries[index] == null)
		{
			Data.Instance.legendaries[index] = rabbit;
		}
		else
		{
			Debug.LogError("Why create an existing legendary?");
		}
		*/
		return rabbit;
	}

	//------------------------------------------------------------------------------------------------

	public bool IsChild
	{
		get { return Age < ADULT_AGE; }
	}

	//------------------------------------------------------------------------------------------------

	public static CAT_COLOR GetColor(string colorStr)
	{
		for (CAT_COLOR i = 0; i < CAT_COLOR.COUNT; i++)
		{
			if (i.ToString().CompareTo(colorStr) == 0)
			{
				return i;
			}
		}

		return CAT_COLOR.INVALID;
	}

	//------------------------------------------------------------------------------------------------

	public string GetAgeStr()
	{
		return Data.GetTimeStr(Age);
	}

	//---------------------------------------------------------------------------------------------

	public int Price(bool sell = false)
	{
		//if (dna.sick)
		//{
		//	return 1;
		//}

		// Les enfants coute moitié moins cher
		float coef = IsChild ? 0.5f : 1.0f;

		return 1 + (int)(Apparence.Price(sell) * coef);
	}
	//---------------------------------------------------------------------------------------------
	public static Color GetColor(CAT_COLOR color)
	{
		switch (color)
		{
			case CAT_COLOR.SPLASH_BLUE: return ZOColor.HexToColor("#65DBE2");
			case CAT_COLOR.SWEET_BLUSH: return ZOColor.HexToColor("#FFB4CF");
			case CAT_COLOR.SUNNY_LEMON: return ZOColor.HexToColor("#FFFA76");
			case CAT_COLOR.YELLOW_BANANA: return ZOColor.HexToColor("#FFEFBA");
			case CAT_COLOR.SNOW_QUEEN: return ZOColor.HexToColor("#FFFFFF");
			case CAT_COLOR.OCEAN_CYAN: return ZOColor.HexToColor("#00BAFF");
			case CAT_COLOR.TANGY_RED: return ZOColor.HexToColor("#E43037");
			case CAT_COLOR.FRESH_LEAF: return ZOColor.HexToColor("#2A962B");
			case CAT_COLOR.ROXY_ORANGEADE: return ZOColor.HexToColor("#FF994B");
			case CAT_COLOR.GREY_MIST: return ZOColor.HexToColor("#D1DEDF");
			case CAT_COLOR.RIPE_BLUE: return ZOColor.HexToColor("#134F9F");
			case CAT_COLOR.PINK_PULSE: return ZOColor.HexToColor("#FA6FF5");
			case CAT_COLOR.LIME_GLOW: return ZOColor.HexToColor("#AFC752");
			case CAT_COLOR.GOLDEN_PEACH: return ZOColor.HexToColor("#D9A767");
			case CAT_COLOR.SHADOW_STONE: return ZOColor.HexToColor("#5D6A72");
			case CAT_COLOR.MIDNIGHT_PLUM: return ZOColor.HexToColor("#3E4258");
			case CAT_COLOR.VIVID_VIOLET: return ZOColor.HexToColor("#27194E");
			case CAT_COLOR.SUSPICIOUS_DISH: return ZOColor.HexToColor("#998221");
			case CAT_COLOR.COCOA_SPICE: return ZOColor.HexToColor("#9F3F14");
			case CAT_COLOR.BLACK: return ZOColor.HexToColor("#000000");
		}

		return UnityEngine.Color.white;
	}

	//---------------------------------------------------------------------------------------------
	public static Color GetColor(CAT_TRUFFE_COLOR color)
	{
		switch (color)
		{
			case CAT_TRUFFE_COLOR.BLACK: return ZOColor.HexToColor("#242121");
			case CAT_TRUFFE_COLOR.DARKGREY: return ZOColor.HexToColor("#634C52");
			case CAT_TRUFFE_COLOR.BROWN: return ZOColor.HexToColor("#855146");
			case CAT_TRUFFE_COLOR.LIGHTBROWN: return ZOColor.HexToColor("#CB7969");
			case CAT_TRUFFE_COLOR.ORANGE: return ZOColor.HexToColor("#F27358");
			case CAT_TRUFFE_COLOR.ORANGEPINK: return ZOColor.HexToColor("#E6726C");
			case CAT_TRUFFE_COLOR.DARKPINK: return ZOColor.HexToColor("#C0687F");
			case CAT_TRUFFE_COLOR.PINK: return ZOColor.HexToColor("#EA83B4");
		}

		return UnityEngine.Color.white;
	}

	//---------------------------------------------------------------------------------------------
	public static Color GetColor(CAT_EYES_COLOR color)
	{
		switch (color)
		{
			case CAT_EYES_COLOR.LIGHT_GREEN:	return ZOColor.HexToColor("#D1CB74");
			case CAT_EYES_COLOR.YELLOW:			return ZOColor.HexToColor("#E5C167");
			case CAT_EYES_COLOR.BROWN:		return ZOColor.HexToColor("#C98151");
			case CAT_EYES_COLOR.DARK_BLUE:	return ZOColor.HexToColor("#739ABD");
			case CAT_EYES_COLOR.DARK_GREEN:	return ZOColor.HexToColor("#789757");
			case CAT_EYES_COLOR.LIGHT_BLUE:	return ZOColor.HexToColor("#92DCE5");
		}

		return UnityEngine.Color.white;
	}

	//------------------------------------------------------------------------------------------------
	public override Material Get2DMaterial()
	{
		return Apparence.Affect2DMaterial();
	}

	//------------------------------------------------------------------------------------------------
	//public Material AffectMaterial(Material material)
	//{
	//	return Apparence.AffectMaterial(material);
	//}

	//------------------------------------------------------------------------------------------------
	public void PreSerialize()
	{
		if (progress != null)
		{
			progress.PreSerialize();
		}
	}

	//------------------------------------------------------------------------------------------------
	public void OnDeserialize()
	{
		if (Age < 0.0)
		{
			Set(Rabbit.ADULT_AGE);
		}
		Apparence.Verify();

		Data.Instance.Unlock(Apparence, false);

		if (progress != null)
		{
			progress.OnDeserialize();
		}
	}
}

//------------------------------------------------------------------------------------------------
