using UnityEngine;
using UnityEngine.UI;
using System.Collections.Generic;
using System.Linq;
using UnityEngine.Rendering;

public class StateTableau : MonoBehaviour
{
    [SerializeField] private Color hintColor;

    [Header("Rfrences UI")]
    public List<GameObject> HintCats;
    public List<bool> isCatClicked; // Tous les boutons  cliquer
    public Slider slider;               // Le slider  remplir
    public Button boutonSuite;          // Le bouton "Suite"  faire apparatre

    [Header("Paramtres")]
    public float valeurParClic = 1f;    // Combien le slider augmente  chaque clic

    private int nbBoutonsCliques = 0;   // Combien de boutons ont t cliqus
    [SerializeField] private int NbCats = 30;           // Nombre total de boutons

    [SerializeField]
    PauseMenu PauseMenu;

    [SerializeField] private float TimerLimit;
    public Button hintButton;
    public Canvas targetCanvas;
    private float timer = 0f;
    private bool canvasIsActive = false;

    [SerializeField] private GameObject ZoomGo;
    private ButtonsZoom Zoom;
    private bool canMove;
    [SerializeField] private Vector2 MaxMove, MinMove;
    private bool moveUp, moveDown, moveLeft, moveRight;
    [SerializeField] private float moveSpeed;

    public float currentZoom;
    [SerializeField] private CatDetector detector;
    [SerializeField] private GameObject CatsParent;

    void Start()
    {

        Zoom = ZoomGo.GetComponent<ButtonsZoom>();
        HintCats.Clear();
        for (int i = 0; i < CatsParent.transform.childCount; i++)
        {
            HintCats.Add(CatsParent.transform.GetChild(i).gameObject);
            isCatClicked.Add(false);
        }
        // Initialisation
        if (slider != null)
        {
            slider.value = 0f;
            slider.maxValue = 100f;
        }

        boutonSuite.gameObject.SetActive(false); // Le bouton suite est cach au dpart

        NbCats = HintCats.Count;

        hintButton.gameObject.SetActive(false);
    }
    private void OnEnable()
    {

    }

    void Update()
    {

        //Pause Menu
        if (Input.GetKeyDown(KeyCode.Escape))
        {
            if (PauseMenu.gameIsPaused)
                PauseMenu.Resume();
            else
                PauseMenu.Pause();
        }


        //Timer & Hint Management
        if (targetCanvas.gameObject.activeInHierarchy)
        {
            if (!canvasIsActive)
            {
                canvasIsActive = true;
                timer = 0f; // Rinitialise le timer quand le canvas devient actif
            }

            timer += Time.deltaTime;

            if (timer >= TimerLimit && !hintButton.gameObject.activeSelf && HintCats.Count > 0)
            {
                hintButton.gameObject.SetActive(true); // Affiche le bouton HINT
            }
        }

        if (Zoom.GetCurrentZoom() >= 1f)
        {
            currentZoom = Zoom.GetCurrentZoom();
            canMove = true;
            MaxMove = GetMaxMove(currentZoom);
            MinMove = -MaxMove;
            //Debug.Log(Zoom.GetCurrentZoom());
        }
        else
        {
            canMove = false;
        }

        if (ZoomGo.GetComponent<RectTransform>().localPosition.y < MinMove.y) ZoomGo.GetComponent<RectTransform>().Translate(0, moveSpeed, 0);
        if (ZoomGo.GetComponent<RectTransform>().localPosition.y > MaxMove.y) ZoomGo.GetComponent<RectTransform>().Translate(0, -moveSpeed, 0);
        if (ZoomGo.GetComponent<RectTransform>().localPosition.x < MinMove.x) ZoomGo.GetComponent<RectTransform>().Translate(moveSpeed, 0, 0);
        if (ZoomGo.GetComponent<RectTransform>().localPosition.x > MaxMove.x) ZoomGo.GetComponent<RectTransform>().Translate(-moveSpeed, 0, 0);


        if (moveUp && ZoomGo.GetComponent<RectTransform>().localPosition.y > MinMove.y)
        {
            //Debug.Log("moveUp");
            ZoomGo.GetComponent<RectTransform>().Translate(0, -moveSpeed, 0);
        }
        if (moveDown && ZoomGo.GetComponent<RectTransform>().localPosition.y < MaxMove.y)
        {
            //Debug.Log("moveDown");
            ZoomGo.GetComponent<RectTransform>().Translate(0, moveSpeed, 0);
        }

        if (moveRight && ZoomGo.GetComponent<RectTransform>().localPosition.x > MinMove.x)
        {
            //Debug.Log("moveRight");
            ZoomGo.GetComponent<RectTransform>().Translate(-moveSpeed, 0, 0);
        }
        if (moveLeft && ZoomGo.GetComponent<RectTransform>().localPosition.x < MaxMove.x)
        {
            //Debug.Log("moveLeft");
            ZoomGo.GetComponent<RectTransform>().Translate(moveSpeed, 0, 0);
        }

    }

    public Vector2 GetMaxMove(float currentZoom)
    {
        Vector2 newMaxMove = Vector2.zero;

        newMaxMove.x = -(1920 - 1920 * Zoom.GetCurrentZoom()) / 2;
        newMaxMove.y = -(1080 - 1080 * Zoom.GetCurrentZoom()) / 2;

        return newMaxMove;
    }

    public void ResetTimer()
    {
        timer = 0f;
    }

    public void OnHintButtonClicked()
    {
        hintButton.gameObject.SetActive(false); // Cache le bouton
        timer = 0f; // Rinitialise le timer

        if (detector.objectToActivate == null || detector.objectToActivate.Count == 0) return;

        

        int randomIndex = Random.Range(0, detector.objectToActivate.Count);
        GameObject randomCat;


        randomCat = detector.objectToActivate[randomIndex];
        //detector.objectToActivate.Remove(detector.objectToActivate[randomIndex]);


        Image buttonImage = randomCat.GetComponent<Image>();
        randomCat.SetActive(true);
        buttonImage.color = hintColor; 

        //Debug.Log(randomIndex + " = Hint button Num");
    }

    // Fonction appele quand un bouton est cliqu
    public void OnBoutonClick(GameObject obj)
    {
        nbBoutonsCliques++;

        // Mettre  jour le slider
        if (slider != null)
            slider.value = nbBoutonsCliques * 100 / NbCats;

        // Vrifier si on atteint le seuil max - 5
        if (slider.value >= 70 && boutonSuite != null)
        {
            boutonSuite.gameObject.SetActive(true);
        }
        //detector.objectToActivate.Remove(obj);
        //Debug.Log("Slider value = " + slider.value);
    }
    public void onClickSuite()
    {
        StateMachine.Instance.changeState(StateMachine.State.WIN);
    }

    public void VerticalMouseHoverMoveSTART(bool isUp)
    {
        if (canMove)
        {
            if (isUp)
            {
                //Debug.Log("START UP!");
                moveUp = true;
            }
            else
            {
                //Debug.Log("START DOWN!");
                moveDown = true;
            }
        }
        else
        {
            moveUp = false;
            moveDown = false;
        }
    }
    public void VerticalMouseHoverMoveSTOP(bool isUp)
    {
        if (canMove)
        {
            if (isUp)
            {
                //Debug.Log("STOP UP!");
                moveUp = false;
            }
            else
            {
                //Debug.Log("STOP DOWN!");
                moveDown = false;
            }
        }
        else
        {
            moveUp = false;
            moveDown = false;
        }
    }
    public void HorizontalMouseHoverMoveSTART(bool isRight)
    {
        if (canMove)
        {
            if (isRight)
            {
                //Debug.Log("START RIGHT!");
                moveRight = true;
            }
            else
            {
                //Debug.Log("START LEFT!");
                moveLeft = true;
            }
        }
        else
        {
            moveRight = false;
            moveLeft = false;
        }
    }
    public void HorizontalMouseHoverMoveSTOP(bool isRight)
    {
        if (canMove)
        {
            if (isRight)
            {
                //Debug.Log("STOP RIGHT!");
                moveRight = false;
            }
            else
            {
                //Debug.Log("STOP LEFT!");
                moveLeft = false;
            }
        }
        else
        {
            moveRight = false;
            moveLeft = false;
        }
    }

}