using UnityEngine;

public class StateMachine : MonoBehaviour
{
    [SerializeField] private GameObject Menu, Win,TableauSelect, MeetTheDevs;
    [SerializeField] private GameObject[] Tableaux;
    [SerializeField] private State state;
    [SerializeField] private GameObject Cat;

    public int CurrentIndex = 0;

    static public StateMachine Instance;
    public enum State{
        MENU,WIN,TABLEAU,TABLEAUSELECT,MEETTHEDEVS
    }

    private void Awake()
    {
        if (Instance != null) Debug.LogError("Double singleton");
        Instance = this;
    }

    void Start()
    {
        changeState(State.MENU);
    }

    public void changeState(State newState)
    {
        state = newState;
        if (state == State.MENU)Cat.SetActive(true);
        else Cat.SetActive(false);
        Menu.SetActive(state==State.MENU);
        TableauSelect.SetActive(state==State.TABLEAUSELECT);
        Win.SetActive(state==State.WIN);
        MeetTheDevs.SetActive(state==State.MEETTHEDEVS);
        if (state == State.TABLEAU)
        {
            SelectTable(0);
        }
        else
        {
            foreach (GameObject tableau in Tableaux)
            {
                tableau.SetActive(false);
            }
        }
    }
    public void changeState(State newState,int Index)
    {
        state = newState;
        Menu.SetActive(state == State.MENU);
        TableauSelect.SetActive(state == State.TABLEAUSELECT);
        Win.SetActive(state == State.WIN);
        if (state == State.TABLEAU)
        {
            SelectTable(Index);
        }
        else
        {
            foreach (GameObject tableau in Tableaux)
            {
                tableau.SetActive(false);
            }
        }
    }
    private void SelectTable(int index)
    {
        CurrentIndex = index;
        for (int i = 0; i < Tableaux.Length; i++) {
            if (i != index) { 
                Tableaux[i].SetActive(false);
            }
            else
            {
                Tableaux[i].SetActive(true);
            }
        }
    }
}
