﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using TMPro;

public enum STATE
{
	ACTIONS,
	CANDY,
	CONSUMABLES,

	INVALID
}

public class MenuBar : MonoBehaviour
{
	private const bool debug = false;

	public CatModel rabbitModel;

	public STATE State { get; private set; } = STATE.INVALID;

	//-------------------------------------------------------------------------------------------------
	[Header("Subs")]
	public RectTransform actionsSub;
	public RectTransform itemsSub;

	public Transform itemsContent;

	[Header("Rabbit Sub")]
	public GameObject foodButton;
	public GameObject candyButton;
	public GameObject consumablesButton;
	public GameObject alarmButton;
	public GameObject sellButton;
	public GameObject hutchButton;
	public GameObject sleepButton;

	public TextMeshProUGUI textNbCandy;
	public TextMeshProUGUI textNbCarrots;
	public TextMeshProUGUI textNbConsomables;
	public TextMeshProUGUI textNbAlarms;

	public Image candyIcon1;
	public Image candyIcon2;
	public Image candyIcon3;
	public Image foodIcon;

	public ItemUI itemUIPrefab;

	//---------------------------------------------------------------------------------------------
	public void Back()
	{
		State = STATE.ACTIONS;
		Refresh();
	}

	//---------------------------------------------------------------------------------------------
	public void Refresh()
	{
		switch (State)
		{
			case STATE.ACTIONS:
			{
				actionsSub.gameObject.SetActive(true);
				itemsSub.gameObject.SetActive(false);

				if (rabbitModel.State == CAT_STATE.SLEEP)
				{
					candyButton.SetActive(false);
					consumablesButton.SetActive(false);
					foodButton.SetActive(false);
					candyButton.SetActive(false);

					/*int nbAlarms = Data.Instance.CountNumberOfCoffee(Item.STATE.STOCK);
					if (nbAlarms <= 0)
					{
						alarmButton.SetActive(false);
					}
					else
					{
						alarmButton.SetActive(true);
						textNbAlarms.text = nbAlarms.ToString();
					}*/
				}
				else
				{
					alarmButton.SetActive(false);

					// Carrot button --------------------------------------------------------------

					/*int nbCarrots = Data.Instance.CountNumberOfFood(Item.STATE.STOCK);
					if (nbCarrots > 0)
					{
						foodButton.SetActive(true);
						textNbCarrots.text = nbCarrots.ToString();
					}
					else
					{
						foodButton.SetActive(false);
					}*/

					// Consumables button ---------------------------------------------------------

					/*int nbConsumables = Data.Instance.CountConsumablesButFood();
					if (nbConsumables > 0)
					{
						consumablesButton.SetActive(true);
						textNbConsomables.text = nbConsumables.ToString();
					}
					else
					{
						consumablesButton.SetActive(false);
					}*/

					// Candies --------------------------------------------------------------------------------

					/*int nbCandy = Data.Instance.CountInStock<Candy>();
					if (nbCandy > 0 && !rabbitModel.Cat.IsLegendary)
					{
						candyButton.SetActive(true);

						CAT_COLOR firstItem = CAT_COLOR.INVALID;
						CAT_COLOR secondItem = CAT_COLOR.INVALID;
						CAT_COLOR thirdItem = CAT_COLOR.INVALID;

						textNbCandy.text = nbCandy.ToString();
						List<Item> items = Data.Instance.items;

						for (int i = 0; i < items.Count; i++)
						{
							Item item = items[i];
							if (item.State == Item.STATE.STOCK && item is Candy candy)
							{
								if (firstItem == CAT_COLOR.INVALID || firstItem == candy.Color)
								{
									firstItem = candy.Color;
								}
								else if (secondItem == CAT_COLOR.INVALID || secondItem == candy.Color)
								{
									secondItem = candy.Color;
								}
								else if (thirdItem == CAT_COLOR.INVALID || thirdItem == candy.Color)
								{
									thirdItem = candy.Color;
								}
							}
						}

						candyIcon1.color = Rabbit.GetColor(firstItem);

						if (secondItem != CAT_COLOR.INVALID)
						{
							candyIcon2.gameObject.SetActive(true);
							candyIcon2.color = Rabbit.GetColor(secondItem);
						}
						else
						{
							candyIcon2.gameObject.SetActive(false);
						}

						if (thirdItem != CAT_COLOR.INVALID)
						{
							candyIcon3.gameObject.SetActive(true);
							candyIcon3.color = Rabbit.GetColor(thirdItem);
						}
						else
						{
							candyIcon3.gameObject.SetActive(false);
						}
					}
					else
					{
						candyButton.SetActive(false);
					}*/
				}

				// Mutation Button ------------------------------------------------------------------------

				/*if (rabbitModel.rabbit.IsLegendary)
				{
					missionButton.SetActive(false);
					sellButton.SetActive(false);
					hutchButton.SetActive(false);
					mutationButton.SetActive(true);
				}
				else */
				if (rabbitModel.Cat.IsLegendary)
				{
					sellButton.SetActive(false);
					hutchButton.SetActive(true);
				}
				else
				{
					sellButton.SetActive(true);
					hutchButton.SetActive(false);
				}

				//if (rabbitModel.rabbit.dna.tired < 0.1f && rabbitModel.State != CAT_STATE.SLEEP)
				//{
				//	sleepButton.SetActive(true);
				//}
				//else
				//{
				//	sleepButton.SetActive(false);
				//}

				break;
			}
			default:
			{
				actionsSub.gameObject.SetActive(false);
				itemsSub.gameObject.SetActive(true);

				itemsContent.DestroyChildren();

				Dictionary<int, ItemUI> itemUIList = new Dictionary<int, ItemUI>();

				/*foreach (Item item in Data.Instance.items)
				{
					if (item == null || item.State != Item.STATE.STOCK) continue;
					if (State == STATE.CANDY && !(item is Candy)) continue;
					if (State == STATE.CONSUMABLES && (!(item is Consumable consumable) || consumable.Type == Consumable.TYPE.FOOD)) continue;

					if (itemUIList.TryGetValue(item.GetInternalType(), out ItemUI itemUI))
					{
						itemUI.Size++;
					}
					else
					{
						itemUI = Instantiate(itemUIPrefab, itemsContent);
						itemUI.Init(this, rabbitModel, item);

						itemUIList.Add(item.GetInternalType(), itemUI);
					}

					itemUI.Refresh();

					// simple anim effect
					itemsContent.GetComponent<RectTransform>().anchoredPosition = Vector3.zero;
				}*/

				break;
			}
		}

		// Alarm button ---------------------------------------------------------------------------



		/*

		switch (rabbitModel.State)
		{
			case CAT_STATE.IDLE:
				break;
			case CAT_STATE.WALKING:
				break;
			case CAT_STATE.SEDUCE:
				break;
			case CAT_STATE.FUCK:
				break;
			case CAT_STATE.EAT:
				break;
			case CAT_STATE.TAKING:
				break;
			case CAT_STATE.SLEEP:
			{
				foodButton.SetActive(false);
				candyButton.SetActive(false);
				consumablesButton.SetActive(false);

				int nbAlarms = Data.Instance.CountNumberOfCoffee(Item.STATE.STOCK);
				if (nbAlarms <= 0)
				{
					alarmButton.SetActive(false);
				}
				else
				{
					alarmButton.SetActive(true);
					textNbAlarms.text = nbAlarms.ToString();
				}
				break;
			}
			case CAT_STATE.SHIT:
				break;
			case CAT_STATE.PUKE:
				break;
			case CAT_STATE.FORCE:
				break;
			case CAT_STATE.SHOT:
				break;
			case CAT_STATE.BUZZ:
				break;
			case CAT_STATE.BEAUTY:
				break;
			case CAT_STATE.GAME:
				break;
			case CAT_STATE.READ:
				break;
			case CAT_STATE.ANGE:
				break;
			case CAT_STATE.DEAD:
				break;
			case CAT_STATE.MENU:
				break;
			case CAT_STATE.HIDE:
				break;
			case CAT_STATE.COUNT:
				break;
			case CAT_STATE.INVALID:
				break;
			default:
				break;
		}*/
	}

	//-------------------------------------------------------------------------------------------------
	public void SelectCandy()
	{
		/*if (Data.Instance.CountInStock<Candy>() > 0)
		{
			State = STATE.CANDY;
			Refresh();
		}*/
	}

	//-------------------------------------------------------------------------------------------------
	public void SelectConsumable()
	{
		/*if (Data.Instance.CountInStock<Consumable>() > 0)
		{
			State = STATE.CONSUMABLES;
			Refresh();
		}*/
	}

	//-------------------------------------------------------------------------------------------------
	public void OnClickFood()
	{
		/*foreach (Item itm in Data.Instance.items)
		{
			if (itm != null && itm.State == Item.STATE.STOCK && itm is Consumable consumable && consumable.Type == Consumable.TYPE.FOOD)
			{
				if (rabbitModel.BeginApply(itm))
				{
					iTween.PunchScale(foodIcon.gameObject, Vector3.one * 1.0f, 0.5f);

					textNbCarrots.text = Data.Instance.CountNumberOfFood(Item.STATE.STOCK).ToString();
				}
				return;
			}
		}*/
	}

	//-------------------------------------------------------------------------------------------------
	public void OnClickFoodLongPress()
	{
		//Dialog.Send(Local.Get("T_FOOD"), Dialog.TYPE.MESSAGE);
	}

	//-------------------------------------------------------------------------------------------------
	public bool ClickedOn(Vector3 position)
	{
		if (gameObject.activeInHierarchy == false)
		{
			return false;
		}

		switch (State)
		{
			case STATE.ACTIONS:
			{
				Rect rect = actionsSub.GetScreenRect(Camera.main);
				return rect.Contains(position);
			}
			case STATE.CANDY:
			case STATE.CONSUMABLES:
			{
				Rect rect = itemsSub.GetScreenRect(Camera.main);
				return rect.Contains(position);
			}
		}

		return false;
	}

	//-------------------------------------------------------------------------------------------------
	public void OnClickSell()
	{
		/*if (Data.NbUnlockedColors > 3)
		{
			StatePlay.Instance.OnClickSell();
		}
		else
		{
			Interface.Instance.ShowToast(Local.Get("Locked"), transform);
		}*/
	}

	//-------------------------------------------------------------------------------------------------
	public void OnClickSellAll()
	{
		//StatePlay.Instance.OnClickSellAll();
	}

	//-------------------------------------------------------------------------------------------------
	public void OnClickInfos()
	{
		if (debug) Debug.Log("OnClicInfos()");

		/*if (DialogInfos.instance == null)
		{
			DialogInfos dialogInfos = Instantiate(DialogManager.DialogInfos);
			dialogInfos.Init(rabbitModel);

			StatePlay.onBack = () => dialogInfos.OnClickClose();
		}
		else
		{
			// Securité check
			DialogInfos.instance.OnClickClose();
		}*/
	}

	//-------------------------------------------------------------------------------------------------
	public void OnClickMutation()
	{
		//StatePlay.Instance.ShowCatalog();
	}

	//-------------------------------------------------------------------------------------------------
	public void OnClickAlarm()
	{
		//Item alarm = Data.Instance.FindConsumable(Consumable.TYPE.COFFEE, Item.STATE.STOCK);

		/*if (alarm != null)
		{
			rabbitModel.BeginApply(alarm);

			Refresh();
		}
		else
		{
			Debug.LogError("No alarm on stock!");
		}*/
	}

	//-------------------------------------------------------------------------------------------------
	public void OnClicGenerateName()
	{
		//rabbitModel.Cat.name = Naming.GeneratePronounceableName();

		OnClickInfos();
	}

	//-------------------------------------------------------------------------------------------------
	public void OnClickHutch()
	{
		//StatePlay.Instance.OnClickHutch();
	}

	//-------------------------------------------------------------------------------------------------
	public void OnClickSleep()
	{
		rabbitModel.SetState(CAT_STATE.SLEEP);
	}

	//-------------------------------------------------------------------------------------------------
}
