﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

[RequireComponent(typeof(Image))]
public class ItemUI : MonoBehaviour
{
	public Text nbText;
	Item item;

	public int Size = 1;

	CatModel rabbitModel;

	MenuBar actionBar;

	public Image imageIcon;
	public Image imageCircle;

	public Material material;

	// --------------------------------------------------------------------------------------------

	public void Init(MenuBar actionBar, CatModel rabbitModel, Item item)
	{
		this.actionBar = actionBar;
		this.rabbitModel = rabbitModel;
		this.item = item;
		Size = 1;
		

		imageIcon.sprite = item.GetSprite();
		
		material = item.Get2DMaterial();
		if (material != null)
		{
			imageIcon.material = material;
		}
	}

	// --------------------------------------------------------------------------------------------

	public void Refresh()
	{
		nbText.text = Size.ToString();
		if (rabbitModel != null)
		{
			//imageCircle.gameObject.SetActive(rabbitModel.Want(item));
		}
	}

	// --------------------------------------------------------------------------------------------

	public Item GetItem()
	{
		return item;
	}

	// --------------------------------------------------------------------------------------------

	

	// --------------------------------------------------------------------------------------------
	

	// --------------------------------------------------------------------------------------------

}
