using System;
using Global;
using TMPro;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.UI;

namespace Menu
{
    public class ShopCanvas : MonoBehaviour
    {
        [SerializeField] private GameObject panelToComplete;
        [SerializeField] private GameObject shopItemPrefab;

        public void OnEnable()
        {
            PopulateShopItems();
        }

        public void OnDisable()
        {
            foreach (Transform child in panelToComplete.transform)
            {
                Destroy(child.gameObject);
            }
        }

        private void PopulateShopItems()
        {
            int populatedcount = 0;
            SkinScheme[] availableSkins = PlayerStatsManager.instance.GetAvailableSkins();
            SkinScheme[] ownedSkins = PlayerStatsManager.instance.GetOwnedSkins();
            foreach (SkinScheme skin in availableSkins)
            {
                GameObject shopItem = Instantiate(shopItemPrefab, panelToComplete.transform);
                shopItem.GetComponent<ShopItem>().skin = skin;
                // If the skin is already owned, disable the purchase button
                if (Array.Exists(ownedSkins, ownedSkin => ownedSkin.skinName == skin.skinName))
                {
                    shopItem.transform.GetChild(0).GetChild(0).gameObject.SetActive(false);
                }
                shopItem.GetComponent<Button>().onClick.AddListener(OnClickPurchase);
                var previewImage = shopItem.transform.GetChild(0).GetComponent<Image>();

                if (skin.previewIcon != null)
                {
                    // Affiche l’icône PNG
                    previewImage.sprite = skin.previewIcon;
                    previewImage.color  = Color.white; // ne pas teinter le sprite
                }
                else
                {
                    // Fallback : simple couleur de la skin
                    previewImage.sprite = null;      // sprite de base du prefab
                    previewImage.color  = skin.skinStartColor;
                }
                shopItem.transform.GetChild(0).GetChild(0).GetChild(1).GetComponent<TextMeshProUGUI>().text = skin.price.ToString();
                populatedcount++;
            }
            
            // get the number of lines of 3 generated based on the populated count
            int numberOfLines = Mathf.CeilToInt(populatedcount / 3f);
            // set the bottom height of the panel to complete based on the number of lines
            RectTransform rectTransform = panelToComplete.GetComponent<RectTransform>();
            rectTransform.sizeDelta = new Vector2(rectTransform.sizeDelta.x, numberOfLines * 200f);
        }

        private static void OnClickPurchase()
        {
            // verify if the player does not already own the skin
            var skinToPurchase = EventSystem.current.currentSelectedGameObject.GetComponent<ShopItem>().skin;
            var ownedSkins = PlayerStatsManager.instance.GetOwnedSkins();
            if (Array.Exists(ownedSkins, ownedSkin => ownedSkin.skinName == skinToPurchase.skinName))
            {
                Debug.Log("Skin already owned.");
                return;
            }
            // Check if the player has the required stars to purchase the skin
            var playerStars = PlayerStatsManager.instance.GetStars();
        
            if (playerStars >= skinToPurchase.price)
            {
                // Deduct stars and add skin to owned skins
                PlayerStatsManager.instance.SetStars(playerStars - skinToPurchase.price);
                PlayerStatsManager.instance.AddOwnedSkin(skinToPurchase.skinName);
                // Disable the purchase button
                EventSystem.current.currentSelectedGameObject.transform.GetChild(0).GetChild(0).gameObject.SetActive(false);
                if (CurrencyCanvas.instance != null)
                {
                    CurrencyCanvas.instance.UpdateCurrencyDisplay();
                }
                Debug.Log("Purchased skin: " + skinToPurchase.skinName);
            }
            else
            {
                Debug.Log("Not enough stars to purchase this skin.");
            }
        }
    }
}
