using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.Serialization;
using UnityEngine.UI;

namespace Menu
{
    public class SettingsCanvas : MonoBehaviour
    {
        [FormerlySerializedAs("_volumeSlider")] [SerializeField] private Slider volumeSlider;
        [SerializeField] private GameObject backgroundUIElement;

        private void OnEnable()
        {
            volumeSlider.onValueChanged.AddListener(OnVolumeChanged);
            volumeSlider.value = AudioListener.volume;
        }
    
        private void OnDisable()
        {
            volumeSlider.onValueChanged.RemoveListener(OnVolumeChanged);
        }
    
        public void OnVolumeChanged(float value)
        {
            AudioListener.volume = value;
        }
    
        public void OnClickCloseSettings()
        {
            //Check if pointing the background UI element, if yes, close the settings panel
            if (EventSystem.current.currentSelectedGameObject != null && EventSystem.current.currentSelectedGameObject == backgroundUIElement)
            {
                MenuManager.instance.ReturnToLevelSelect();
            }
        }
    }
}
