using Global;
using UnityEngine;
using UnityEngine.UI;

namespace Menu
{
    public class CustomizeCanvas : MonoBehaviour
    {
        [SerializeField] private GameObject panelToComplete;
        [SerializeField] private GameObject customizeItemPrefab;

        [SerializeField] private GameObject checkmarkPrefab;
        private GameObject _checkmark;
        // Start is called once before the first execution of Update after the MonoBehaviour is created
        public void OnEnable()
        {
            PopulateCustomizeItems();
        }

        public void OnDisable()
        {
            foreach (Transform child in panelToComplete.transform)
            {
                Destroy(child.gameObject);
            }
        }

        private void PopulateCustomizeItems()
        {
            int populatedcount = 0;
            SkinScheme[] ownedSkins = PlayerStatsManager.instance.GetOwnedSkins();
            foreach (SkinScheme skin in ownedSkins)
            {
                GameObject customizeItem = Instantiate(customizeItemPrefab, panelToComplete.transform);
                customizeItem.GetComponent<CustomizeItem>().skin = skin;
                customizeItem.GetComponent<UnityEngine.UI.Button>().onClick.AddListener(OnClickCustomize);
                var previewImage = customizeItem.transform.GetChild(0).GetComponent<Image>();

                if (skin.previewIcon != null)
                {
                    // Affiche l’icône PNG
                    previewImage.sprite = skin.previewIcon;
                    previewImage.color  = Color.white; // ne pas teinter le sprite
                }
                else
                {
                    // Fallback : simple couleur de la skin
                    previewImage.sprite = null;      // sprite de base du prefab
                    previewImage.color  = skin.skinStartColor;
                }
                populatedcount++;
            }
            
            // get the number of lines of 3 generated based on the populated count
            int numberOfLines = Mathf.CeilToInt(populatedcount / 3f);
            // set the bottom height of the panel to complete based on the number of lines
            RectTransform rectTransform = panelToComplete.GetComponent<RectTransform>();
            rectTransform.sizeDelta = new Vector2(rectTransform.sizeDelta.x, numberOfLines * 200f);
        
            // set the checkmark to the current skin
            SkinScheme currentSkin = PlayerStatsManager.instance.GetCurrentSkin();
            for (int i = 0; i < panelToComplete.transform.childCount; i++)
            {
                GameObject customizeItem = panelToComplete.transform.GetChild(i).gameObject;
                try
                {
                    if (customizeItem.GetComponent<CustomizeItem>().skin.skinName == currentSkin.skinName)
                    {
                        _checkmark = Instantiate(checkmarkPrefab, customizeItem.transform);
                        _checkmark.GetComponent<RectTransform>().anchoredPosition = Vector2.zero;
                        break;
                    }
                }
                catch (System.Exception)
                {
                    Debug.Log("Customize item could not be created");
                }
            }
        }

        private void OnClickCustomize()
        {
            var skinToCustomize = UnityEngine.EventSystems.EventSystem.current.currentSelectedGameObject.GetComponent<CustomizeItem>().skin;
            PlayerStatsManager.instance.SetCurrentSkin(skinToCustomize.skinName);
        
            // move the checkmark to the selected customize item
            if (_checkmark != null)
            {
                Destroy(_checkmark);
            }
            GameObject selectedItem = UnityEngine.EventSystems.EventSystem.current.currentSelectedGameObject;
            _checkmark = Instantiate(checkmarkPrefab, selectedItem.transform);
            _checkmark.GetComponent<RectTransform>().anchoredPosition = Vector2.zero;
        }
    }
}