using Global;
using UnityEngine;

[CreateAssetMenu(fileName = "SoundCollection", menuName = "ScriptableObjects/SoundCollection", order = 1)]
public class SoundCollection : ScriptableObject
{
    public SoundAsset[] soundClips;
    
    public AudioClip GetSoundClip(Sound soundType)
    {
        foreach (SoundAsset soundAsset in soundClips)
        {
            if (soundAsset.soundType == soundType)
            {
                return soundAsset.soundClip;
            }
        }
        return null;
    }
}
