using UnityEngine;
using UnityEngine.SceneManagement;
using System.Collections;

public class SceneTransitionManager : MonoBehaviour
{
    public static SceneTransitionManager instance;

    private void Awake()
    {
        if (instance == null)
        {
            instance = this;
            DontDestroyOnLoad(gameObject);
        }
        else
        {
            Destroy(gameObject);
        }
    }

    public void GoToScene(string sceneName)
    {
        StartCoroutine(Transition(sceneName));
    }

    private IEnumerator Transition(string sceneName)
    {
        // 1) Load the loading scene asynchronously
        AsyncOperation loadLoading = SceneManager.LoadSceneAsync("Loading", LoadSceneMode.Additive);
        while (!loadLoading.isDone)
            yield return null;

        // 2) Unload the current active scene (optional)
        string current = SceneManager.GetActiveScene().name;
        AsyncOperation unload = SceneManager.UnloadSceneAsync(current);
        while (unload != null && !unload.isDone)
            yield return null;

        // 3) Load the target scene asynchronously
        AsyncOperation loadTarget = SceneManager.LoadSceneAsync(sceneName, LoadSceneMode.Additive);
        while (!loadTarget.isDone)
            yield return null;

        // 4) Remove the loading scene
        AsyncOperation unloadLoading = SceneManager.UnloadSceneAsync("Loading");
        while (!unloadLoading.isDone)
            yield return null;

        // 5) Set the new scene active
        SceneManager.SetActiveScene(SceneManager.GetSceneByName(sceneName));
    }
}