using System;
using Global;
using TMPro;
using UnityEngine;

namespace Game
{
    public class ResultsCanvas : MonoBehaviour
    {
        [SerializeField] private Sprite starGrey;
        [SerializeField] private Sprite starYellow;
        private void OnEnable()
        {
            var finalScore = GameManager.instance.score;
            Debug.Log("Final Score: " + finalScore);
            //Display score 
            transform.parent.GetChild(0).GetChild(4).GetComponent<TextMeshProUGUI>().text = "Score: " + finalScore.ToString();
            //Update stars
            var starsEarned = 0;
            if (PlayerStatsManager.instance == null)
            {
                Debug.LogWarning("PlayerStatsManager instance is null!");
            }
            else if (PlayerStatsManager.instance.currentLevelToPlay == null)
            {
                Debug.LogWarning("PlayerStatsManager.instance.currentLevelToPlay is null!");
            }
            else
            {
                var currentLevel = PlayerStatsManager.instance.currentLevelToPlay;
                if (finalScore >= currentLevel.scoreForStar1) starsEarned = 1;
                if (finalScore >= currentLevel.scoreForStar2) starsEarned = 2;
                if (finalScore >= currentLevel.scoreForStar3) starsEarned = 3;
                // Display victory of defeat
                var previousStarsCollected = PlayerStatsManager.instance.GetLevelStarsCollected(PlayerStatsManager.instance.GetCurrentLevelIndex());
                // if the player earned more stars than before, display victory
                if (starsEarned > Array.FindAll(previousStarsCollected, collected => collected).Length)
                {
                    transform.parent.GetChild(0).GetChild(0).GetComponent<TextMeshProUGUI>().text = "Victory !";
                    SoundManager.Instance.PlaySound(Sound.END_LEVEL_VICTORY);
                }
                else if (GameManager.instance.timeBeforeEnd > 0)
                {
                    return;
                }
                else
                {
                    transform.parent.GetChild(0).GetChild(0).GetComponent<TextMeshProUGUI>().text = "Defeat...";
                    SoundManager.Instance.PlaySound(Sound.END_LEVEL_DEFEAT);
                }
        
                // if score is better than previous best score, update it
                var currentLevelIndex = PlayerStatsManager.instance.GetCurrentLevelIndex();
                var previousBestScore = int.Parse(PlayerStatsManager.instance.GetLevelBestScore(currentLevelIndex));
                if (finalScore > previousBestScore)
                {
                    PlayerStatsManager.instance.UpdateLevelBestScore(currentLevelIndex, finalScore);
                }
                // add new earned stars to the player's total stars
                var newStarsCollected = starsEarned - Array.FindAll(previousStarsCollected, collected => collected).Length;
                if (newStarsCollected > 0)
                {
                    var totalStars = PlayerStatsManager.instance.GetStars();
                    PlayerStatsManager.instance.SetStars(totalStars + newStarsCollected);
                    // update the stars collected for this level
                    PlayerStatsManager.instance.UpdateLevelStarsCollected(currentLevelIndex, starsEarned);
                }
            
            }

            // use child 1, 2, 3 to display stars
            for (var i = 0; i < 3; i++)
            {
                transform.parent.GetChild(0).GetChild(i + 1).GetComponent<UnityEngine.UI.Image>().sprite = i < starsEarned ? starYellow : starGrey;
            }
        }
    }
}
