using UnityEngine;
using UnityEngine.InputSystem;

namespace Game
{
    public class ClickAndKill : MonoBehaviour
    {
        private Vector2 _pointerPosition;
        public void OnPointerPress(InputValue value)
        {
            //When clicking on the screen, raycast and check if we hit an enemy if hitting an enemy, destroy it
            Ray ray = Camera.main.ScreenPointToRay(_pointerPosition);
            Debug.Log(ray.direction);
            RaycastHit hit;
            //Draw the ray for debugging
            Debug.DrawRay(ray.origin, ray.direction * 100, Color.red, 15f);
            if (Physics.Raycast(ray, out hit))
            {
                if (hit.collider.CompareTag("Enemy"))
                {
                    hit.collider.gameObject.GetComponent<Enemy>().KillEnemy();
                }
            }
        }
    
        public void OnPointerPosition(InputValue value)
        {
            // get the pointer position
            Vector2 pointerPosition = value.Get<Vector2>();
            _pointerPosition = pointerPosition;
            //Debug.Log("Pointer position: " + pointerPosition);
        }
    }
}
