﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class Cow : MonoBehaviour
{
	public Transform PointZone0;
	public Transform PointZone1;

	public Animator animator;

	public GameObject cowModel;
	public GameObject stagModel;

	Vector3 axeX;
	Vector3 axeZ;

	float alarm = -1.0f;
	float dist = 0.0f;
	Vector3 destination;

	//---------------------------------------------------------------------------------------------

	private void Start()
	{
		//axeX = PointZone0.position - PointZone1.position;
		axeZ = axeX;

		axeX.z = 0.0f;
		axeX.y = 0.0f;
		axeZ.x = 0.0f;

		RefreshModel();
	}

	// 

	public void RefreshModel()
	{
		/*if (Auras.stag)
		{
			stagModel.SetActive(true);
			cowModel.SetActive(false);
			animator = stagModel.GetComponent<Animator>();
		}
		else
		{
			cowModel.SetActive(true);
			stagModel.SetActive(false);
			animator = cowModel.GetComponent<Animator>();
		}*/


		animator.SetBool("move", dist > 0.01f);
	}

	//---------------------------------------------------------------------------------------------

	private void Update()
	{
		if (alarm < Time.time)
		{
			// Ask for move

			//destination = PointZone1.position + axeX * UnityEngine.Random.value + axeZ * UnityEngine.Random.value;
			transform.LookAt(destination);
			transform.Rotate(0f, 180f, 0f);
			dist = 1.0f;
			animator.SetBool("move", true);

			alarm = Time.time + UnityEngine.Random.Range(30.0f, 120.0f);
			return;
		}

		if (dist > 0.0f)
		{
			Vector3 direction = destination - transform.position;
			dist = direction.magnitude;

			if (dist > 0.5f)
			{
				transform.position += direction * 0.1f * Time.deltaTime / dist;
			}
			else
			{
				dist = 0.0f;
				animator.SetBool("move", false);

				/*if (Auras.stag && Random.value > 0.5f)
				{
					animator.Play("Shake");
				}*/

			}
		}
	}

	//---------------------------------------------------------------------------------------------
}
