﻿Shader "Bunniiies/RedToColor"
{
    Properties
    {
        _MainTex ("Texture", 2D) = "white" {}
		_Color("Color",Color) = (1.0,1.0,1.0,1.0)

		  // required for UI.Mask
         _StencilComp ("Stencil Comparison", Float) = 8
         _Stencil ("Stencil ID", Float) = 0
         _StencilOp ("Stencil Operation", Float) = 0
         _StencilWriteMask ("Stencil Write Mask", Float) = 255
         _StencilReadMask ("Stencil Read Mask", Float) = 255
		  _ColorMask ("Color Mask", Float) = 15
    }
    SubShader
    {
        ZWrite Off
        Lighting Off
        Fog { Mode Off }

		Blend SrcAlpha OneMinusSrcAlpha 

	   // No culling or depth
        //Cull Off ZWrite Off ZTest Always

		// required for UI.Mask
         Stencil
         {
             Ref [_Stencil]
             Comp [_StencilComp]
             //Pass [_StencilOp] 
             ReadMask [_StencilReadMask]
             //WriteMask [_StencilWriteMask]
         }
         // ColorMask [_ColorMask]


        Pass
        {
            CGPROGRAM
            #pragma vertex vert
            #pragma fragment frag

            #include "UnityCG.cginc"

            struct appdata
            {
                float4 vertex : POSITION;
                float2 uv : TEXCOORD0;
            };

            struct v2f
            {
                float2 uv : TEXCOORD0;
                float4 vertex : SV_POSITION;
            };

            v2f vert (appdata v)
            {
                v2f o;
                o.vertex = UnityObjectToClipPos(v.vertex);
                o.uv = v.uv;
                return o;
            }

            sampler2D _MainTex;
			float4 _Color;

            fixed4 frag (v2f i) : SV_Target
            {
                fixed4 col = tex2D(_MainTex, i.uv);
                
				float ratio = clamp(2.0f * (col.x - 0.2f) - (col.y + col.z), 0.0f, 1.0f);

				/*if (0.5f * col.x / col.z > 1.0f)*/
				//if (col.x / (col.y + col.z) > 0.75f)
				//{
					col.rgb = _Color * ratio + col * (1.0f - ratio);
				//}

				return col;
            }
            ENDCG
        }
    }
}
