using UnityEngine;

public enum State
{
	MAINMENU,
	OPTIONS,
	HOWTOPLAY,
	CREDITS,
	GAME,
	ENDGAMEWIN,
	ENDGAMELOSE
}

public class StateMachineUI : MonoBehaviour
{
	static public StateMachineUI instance;

	public State currentState;

	public GameObject guiMainMenu;
	public GameObject guiHowToPlay;
	public GameObject guiOptions;
	public GameObject guiCredits;
	public GameObject guiGame;
	public GameObject guiEndgameWin;
	public GameObject guiEndgameLose;

	public AudioClip musicMenu;
	public AudioClip musicGame;

	public GameObject prefabDecor;
	private GameObject cloneDecor;

	private State tmpState;

	private void Awake()
	{
		if (instance != null) Debug.LogError("Plusieurs instances de StateMachineUI");
		instance = this;
	}

	// Start is called once before the first execution of Update after the MonoBehaviour is created
	void Start()
	{
		guiHowToPlay.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
		guiMainMenu.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
		guiCredits.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
		guiOptions.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
		guiGame.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
		guiEndgameWin.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
		guiEndgameLose.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;

		currentState = State.MAINMENU;
	}

	// Update is called once per frame
	void Update()
	{
		guiMainMenu.SetActive(currentState == State.MAINMENU);
		guiHowToPlay.SetActive(currentState == State.HOWTOPLAY);
		guiOptions.SetActive(currentState == State.OPTIONS);
		guiCredits.SetActive(currentState == State.CREDITS);
		guiGame.SetActive(currentState == State.GAME);
		guiEndgameWin.SetActive(currentState == State.ENDGAMEWIN);
		guiEndgameLose.SetActive(currentState == State.ENDGAMELOSE);

		if (currentState == State.GAME)
		{
			if (GetComponent<AudioSource>().isPlaying && tmpState != currentState)
				GetComponent<AudioSource>().Stop();
			else if (!GetComponent<AudioSource>().isPlaying)
			{
				GetComponent<AudioSource>().clip = musicGame;
				GetComponent<AudioSource>().Play();
			}
		} 
		else
		{
			if (GetComponent<AudioSource>().isPlaying && tmpState == State.GAME)
				GetComponent<AudioSource>().Stop();
			else if (!GetComponent<AudioSource>().isPlaying)
			{
				GetComponent<AudioSource>().clip = musicMenu;
				GetComponent<AudioSource>().Play();
			}
		}

		tmpState = currentState;
	}

	public void ResetRoom()
	{
		for (int i = 0; i < prefabDecor.transform.childCount; i++)
		{
			prefabDecor.transform.GetChild(i).gameObject.SetActive(true);
		}
	}

	public void InstantiateDecor()
	{
		cloneDecor = Instantiate(prefabDecor);
	}

	public void DestroyDecor()
	{
		if (cloneDecor != null)
			Destroy(cloneDecor);
	}
}
