using TMPro;
using UnityEngine;
using UnityEngine.Events;

public class StateGame : MonoBehaviour
{
	public float gameDuration = 90f;
	public GameObject guiTextTimer;
	public GameObject guiTextScore;
	public GameObject guiTextPoints;
	public UnityEvent OnEndGame;
	public float timer {get; private set;}
	public int score {get; private set;}

	public static StateGame instance;

	private void Awake()
	{
		if (instance != null) Debug.LogError("Plusieurs instances de StateGame");
		instance = this;
	}

	private void OnEnable()
	{
		timer = 0f;
		score = 0;
		guiTextScore.GetComponent<TextMeshProUGUI>().text = string.Empty;
	}

	private void Update()
	{
		timer += Time.deltaTime;
		guiTextTimer.GetComponent<TextMeshProUGUI>().text = (gameDuration - timer).ToString("0.0");

		if (timer >= gameDuration)
		{
			OnEndGame.Invoke();
			StateMachineUI.instance.currentState = State.ENDGAMELOSE;
		}
	}

	public void OnTouchMouse()
	{
		OnEndGame.Invoke();
		StateMachineUI.instance.currentState = State.ENDGAMEWIN;
	}

	private float sizeSpawnRect = 200;

	/// <summary>
	/// OnSpawnPoints is a method to spawn UI Text elements that display points earned by the player when
	/// destroying elements in the scene.
	/// OnSpawnPoints can be changed to spawn points with a raycast of the destroyed object, or to be
	/// spawned directly in world space.
	/// </summary>
	public void OnSpawnPoints()
	{
		float x = Random.Range(GetComponent<RectTransform>().rect.xMin + sizeSpawnRect, GetComponent<RectTransform>().rect.xMax - sizeSpawnRect);
		float y = Random.Range(GetComponent<RectTransform>().rect.yMin + sizeSpawnRect, GetComponent<RectTransform>().rect.yMax - sizeSpawnRect);
		GameObject newInstance = Instantiate(guiTextPoints, new Vector3(x, y, 0), Quaternion.identity);
		newInstance.transform.SetParent(transform, false);

		int tmpScore = Random.Range(100, 301);
		newInstance.GetComponent<TextMeshProUGUI>().text = "+" + tmpScore.ToString() + " pts !";

		UpdateScore(tmpScore);
	}
	
	/// <summary>
	/// 
	/// </summary>
	/// <param name="numberPoints">How many points the player wins.</param>
	/// <param name="positionInCanvas">This parameters has to be relative to the GameObject that Player has crushed.</param>
	public void OnSpawnPoints(int numberPoints, Vector2 positionInCanvas)
	{
		GameObject newInstance = Instantiate(guiTextPoints, positionInCanvas, Quaternion.identity);
		newInstance.transform.SetParent(transform, false);

		newInstance.GetComponent<RectTransform>().anchoredPosition = new Vector3(positionInCanvas.x, positionInCanvas.y, 0);
		newInstance.GetComponent<TextMeshProUGUI>().text = "+" + numberPoints.ToString() + " pts !";
		Debug.Log($"{newInstance.transform.position}");

		UpdateScore(numberPoints);
	}

	public void UpdateScore(int score)
	{
		this.score += score;
		guiTextScore.GetComponent<TextMeshProUGUI>().text = this.score.ToString();
	}
}
