using UnityEngine;
using UnityEngine.Events;
using UnityEngine.InputSystem;

public class S_CatGrabBehavior : MonoBehaviour
{
    public S_Mouse currentTargetMouse;

    [Header("Particles")]
    ParticleSystem.EmissionModule emissionModule;
    public GameObject effectParticles;

    public UnityEvent OnMouseGrabbed;


    private void Start()
    {
        emissionModule = effectParticles.GetComponent<ParticleSystem>().emission;
        //emissionModule.enabled = false;
    }

	public void Grab(InputAction.CallbackContext context)
    {
        if (context.action.WasPressedThisFrame())
        {
            TryGrabMouse();
        }
    }

    private void TryGrabMouse()
    {
        if (currentTargetMouse != null)
        {
            // On dtruit le GameObject de la souris
            currentTargetMouse.gameObject.SetActive(false);
            effectParticles.SetActive(false);
            //emissionModule.enabled = false;
            currentTargetMouse = null;
            OnMouseGrabbed.Invoke();
        }
    }

    public void SetTargetMouse(S_Mouse mouse)
    {
        currentTargetMouse = mouse;
        effectParticles.SetActive(true);

        //emissionModule.enabled = true;
    }

    public void RemoveTargetMouse(S_Mouse mouse)
    {
        if (currentTargetMouse == mouse)
        {
            currentTargetMouse = null;
            effectParticles.SetActive(false);

            //emissionModule.enabled = false;
        }
    }
}
