using UnityEngine;
using UnityEngine.Events;

public class ExplosionOnTrigger : MonoBehaviour
{
    public GameObject explosionParticleEffect;
    public int valueObject = 100;

    public UnityEvent onExplosion = new UnityEvent();

    private void Start()
    {
        onExplosion.AddListener(Explode);
    }


    private void OnTriggerEnter(Collider other)
	{
		if (other.CompareTag("Player"))
        {
            onExplosion?.Invoke();
        }
    }

    private void Explode()
    {
        GameObject explosionGo = Instantiate(explosionParticleEffect, transform.position, Quaternion.identity);
        //gameObject.SetActive(false);

        AudioClip audio = AudioSingleton.instance.GetAudioClip(gameObject.tag);

        if (audio != null)
        {
            explosionGo.GetComponent<AudioSource>().clip = audio;
            explosionGo.GetComponent<AudioSource>().pitch = Random.Range(0.8f, 1f);
            explosionGo.GetComponent<AudioSource>().Play();
        }

        CastPointsOnScreen();
    }

    private void CastPointsOnScreen()
    {
        Vector2 v = Camera.main.WorldToScreenPoint(transform.position);
		StateGame.instance.OnSpawnPoints(valueObject, v);
	}
}
