using UnityEngine;

public class CameraScript : MonoBehaviour
{
    [Header("Target Settings")]
    public Transform target;          // The character or object to follow

    [Header("Camera Settings")]
    public Vector3 offset = new Vector3(0, 5, -10);  // Offset from target
    public float smoothSpeed = 0.125f;               // How smooth the camera moves

    [Header("Rotation Settings")]
    public bool lookAtTarget = true;  // If true, camera looks at target

    void LateUpdate()
    {
        if (target == null) return;

        // Desired position based on target + offset
        Vector3 desiredPosition = target.position + offset;

        // Smoothly interpolate between current and desired position
        Vector3 smoothedPosition = Vector3.Lerp(transform.position, desiredPosition, smoothSpeed);

        // Apply position
        transform.position = smoothedPosition;

        // Make camera look at the target
        if (lookAtTarget)
        {
            transform.LookAt(target); 
        }
    }
}