using System;
using System.Collections.Generic;
using UnityEngine;

[Serializable]
public class AudioToTag
{
	public string tag;
	public AudioClip audio;
}

public class AudioSingleton : MonoBehaviour
{
    public static AudioSingleton instance;

    public List<AudioToTag> list;

    public void Awake()
    {
        if (instance == null)
        {
            instance = this;
        } 
        else
        {
            Debug.LogError("There is already a AudioSingleton");
        }
    }

    public AudioClip GetAudioClip(string tag)
    {
        foreach (AudioToTag att in list)
        {
            if (att.tag == tag)
            {
                return att.audio;
            }
        }

        return null;
    }
}
