﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public abstract class Item
{
	//------------------------------------------------------------------------------------------------

	public enum STATE
	{
		STOCK,
		GARDEN,
		INVALID
	}

	public STATE State;

	public Vector2 position;
	public Quaternion rotation;

	//------------------------------------------------------------------------------------------------

	public void RandomizePosition()
	{
		position = new Vector2(Random.Range(0.1f, 0.9f), Random.value);
		rotation = Quaternion.Euler(0, Random.Range(70.0f, 110.0f), 0);
	}

	//------------------------------------------------------------------------------------------------

	public Item()
	{
		if (!(this is Cat))
		{
			try
			{
				position = new Vector2(Random.Range(0.1f, 0.9f), Random.value);
				rotation = Quaternion.Euler(0, Random.Range(70.0f, 110.0f), 0);
			}
			catch
			{
				// pas sur le main thread
				position = Vector2.zero;
				rotation = Quaternion.identity;
			}
		}
	}

	//------------------------------------------------------------------------------------------------
	public Item Clone()
	{
		return this.MemberwiseClone() as Item;
	}

	//------------------------------------------------------------------------------------------------

	static public Item GetRandom(bool linear = false)
	{
		int nb = Random.Range(0, 8);

		return null;
	}

	public abstract Sprite GetSprite();

	public abstract string GetName();

	public abstract string GetDesc();

	//------------------------------------------------------------------------------------------------

	public virtual Material Get2DMaterial()
	{
		return null;
	}

	//------------------------------------------------------------------------------------------------
	public virtual int Price()
	{
		return 1;
	}

	//------------------------------------------------------------------------------------------------
	public string PriceStr()
	{
		int price = Price();

		return "0";
	}

	//------------------------------------------------------------------------------------------------

	public virtual Color GetColor()
	{
		return Color.white;
	}

	//------------------------------------------------------------------------------------------------

	public virtual bool IsEat()
	{
		return false;
	}

	//------------------------------------------------------------------------------------------------

	public virtual void Win()
	{
		State = Item.STATE.STOCK;
		//Data.Instance.Add(this);
	}

	//------------------------------------------------------------------------------------------------

	public abstract int GetInternalType();
	
	//------------------------------------------------------------------------------------------------
}
