﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[CreateAssetMenu(menuName = "ScriptableObjects/Interface")]
public class Interface : ScriptableObject
{
	public static Interface Instance
	{
		get
		{
			instance ??= Resources.Load<Interface>("Interface");
			return instance;
		}		
	}

	static Interface instance = null;

	public static Sprite customSprite;	

	// --------------------------------------------------------------------------------------------
	// Colors

	[Header("Colors")]

	public Color colorRed = new Color(1.0f, 0.52f, 0.47f);
	public Color colorBack = new Color(0.12f, 0.34f, 0.5f, 0.4f);
	public Color colorCyan = new Color(0f, 0.84f, 0.86f);


	// Shapes
	public Texture2D[] shapeTextureList;
	public Sprite[] shapeIconList;

	public Texture2D[] zoneTextureList;

	public Texture2D[] ShapeList;

	// Rewards

	public Material spriteMaterial;

	public Sprite diamondIcon;
	public Sprite goldIcon;
	public Sprite money1Icon;
	public Sprite money2Icon;
	public Sprite money3Icon;
	public Sprite money4Icon;
	public Sprite hutchIcon;
	public Sprite carrotIcon;
	public Sprite speedUpIcon;
	public Sprite noMosaicIcon;
	public Material carrotMaterial;
	public Sprite candyIcon;
	public Sprite couponIcon;
	public Sprite couponLegendaireIcon;
	public Material mushroomMaterial;
	public Material candyMaterial;
	public Material couponMaterial;
	public Sprite rabbitIcon;
	public Sprite giftIcon;
	public Material rabbitMaterial;
	public Material rabbit2DMaterial;
	public Material earMaterial;
	public Material transparentMaterial;


	[Header("Icons")]
	[SerializeField] private Sprite consumableIconSoap;
	[SerializeField] private Sprite consumableIconViagra;
	[SerializeField] private Sprite consumableIconHeal;
	[SerializeField] private Sprite consumableIconFood;
	[SerializeField] private Sprite consumableIconInverso;
	[SerializeField] private Sprite consumableIconCoffee;
	[SerializeField] private Sprite consumableIconChilliPepper;
	[SerializeField] private Sprite consumableIconDrug;
	[SerializeField] private Sprite consumableIconPoison;
	[SerializeField] private Sprite consumableIconZombie;
	[SerializeField] public Sprite consumableIconBasket;

	public Sprite noneSprite;
	public Material voidMat;
	

	// --------------------------------------------------------------------------------------------

	// --------------------------------------------------------------------------------------------

	[Header("Icons Sets")]
	[SerializeField] private Sprite setIconBed;
	[SerializeField] private Sprite setIconCarpet;
	[SerializeField] private Sprite setIconPlant;
	[SerializeField] private Sprite setIconFrame;
	[SerializeField] private Sprite setIconWall;
	[SerializeField] private Sprite setIconDresser;
	[SerializeField] private Sprite setIconGround;
	[SerializeField] private Sprite setIconLamp;
	

	// --------------------------------------------------------------------------------------------

	[Header("Icons Flowers")]

	[SerializeField] private Sprite spriteTomate;
	[SerializeField] private Sprite spriteRose;
	[SerializeField] private Sprite spriteJaune;
	[SerializeField] private Sprite spriteBleu;
	[SerializeField] private Sprite spriteBlanc;
	[SerializeField] private Sprite spritePhoto;
	[SerializeField] private Sprite spriteColor;

	

	// --------------------------------------------------------------------------------------------

	public Sprite[] permanentIcon;

	[SerializeField] private Sprite[] bulleList;

	[Header("FX")]

	public ParticleSystem psHeal;
	public ParticleSystem psHoly;
	public ParticleSystem psShiny;
	public ParticleSystem psCoin;
	public ParticleSystem psHeartExpose;
	public ParticleSystem psHeartEmit;
	public ParticleSystem psSleeping;
	public ParticleSystem psExplode;
	public ParticleSystem psReadyForSex;
	public ParticleSystem psZombieDirt;
	public ParticleSystem psSickEffect;
	public ParticleSystem psShitSmoke;
	public ParticleSystem psVomit;
	public ParticleSystem psBloodGrowing;
	public ParticleSystem psSmoke;
	public ParticleSystem psCarrotSlpatWide;
	public ParticleSystem psWash;
	public ParticleSystem psMagicCharge;
	public ParticleSystem psNukeColored;
	public ParticleSystem psConfettiBlast;
	public ParticleSystem psConfettiBlastBlue;
	public ParticleSystem psSmokeExplosionWhite;
	public ParticleSystem psCartoonyBodySlam;
	public ParticleSystem psMagicMissilesSoftBlue;
	public ParticleSystem psCandyWin;
	public ParticleSystem psCandyLose;
	public ParticleSystem psNovaLightningBlue;
	public ParticleSystem psHitFox;

	[Header("Icons Model Prefabs")]

	

	// Consumable Model

	

	// Permanents

	

	
	public GameObject shitPrefab;
	public GameObject coinPrefab;

	public CatModel catPrefab;

	[Header("Find a header name")]
	public GameObject wings;
	public GameObject torus;


	public Sprite[] sexPositions;



	public GameObject king;
	public GameObject star;
	public GameObject vortex;

	//---------------------------------------------------------------------------------------------

	

	//---------------------------------------------------------------------------------------------

	public Sprite GetBulle(SPRITE_BULLE bulle)
	{
		if ((int)bulle >= bulleList.Length || bulle < 0)
		{
			Debug.Log("GetBulle " + bulle);
			return null;
		}

		return bulleList[(int)bulle];
	}

	//---------------------------------------------------------------------------------------------
	public Texture2D GetShapeTexture(CAT_SHAPE shape)
	{
		if ((int)shape >= shapeTextureList.Length || shape < 0)
		{
			Debug.LogError("GetTextureShape out of range " + shape);
			return null;
		}

		return shapeTextureList[(int)shape];
	}

	//---------------------------------------------------------------------------------------------
	public Texture2D GetZoneTexture(CAT_ZONE zone)
	{
		if ((int)zone >= zoneTextureList.Length || zone < 0)
		{
			Debug.LogError("GetTextureZone out of range " + zone);
			return null;
		}

		return zoneTextureList[(int)zone];
	}


	//---------------------------------------------------------------------------------------------

	

	//---------------------------------------------------------------------------------------------

	 

	//---------------------------------------------------------------------------------------------
}
