using System;
using UnityEngine;
using UnityEngine.UI;

public class GamesManager : MonoBehaviour
{
    float time;
    public GameObject sliderRef;
    public float Timer;
    public Manager NextGame;
    public Text Counter;
    Vector3 scale;
    [SerializeField] string endMessage;

    [SerializeField] GameObject globalCanvas, localCanvas, background;
    Slider slider;

    [SerializeField] AudioSource audioSource;
    [SerializeField] AudioClip sfxNumbers, sfxGo;
    int avancement;

    public void OnNext()
    {
        if (Application.isPlaying) {
            GameManager.Instance.SetManager(NextGame);
        }
    }

    // Start is called once before the first execution of Update after the MonoBehaviour is created
    void OnEnable()
    {
        slider = sliderRef.GetComponent<Slider>();
        time = -4f;
        Counter.text = "3";
        audioSource.PlayOneShot(sfxNumbers);
        background.SetActive(true);
        avancement = 3;
    }

    void CounterScaling()
    {
        scale = Vector3.one * (time % 1f + 1f);
        Counter.transform.localScale = scale;
    }

    void CounterChanging()
    {
        if (Application.isPlaying && -3f <= time && time <= -2f)
        {
            Counter.text = "2";
            if (avancement == 3)
            {
                audioSource.PlayOneShot(sfxNumbers);
                avancement--;
            }
        }
        if (Application.isPlaying && -2f <= time && time <= -1f)
        {
            Counter.text = "1";
            if (avancement == 2)
            {
                audioSource.PlayOneShot(sfxNumbers);
                avancement--;
            }
        }
        if (Application.isPlaying && time >= -1f && time <= -0.2f)
        {
            Counter.text = endMessage;
            if (avancement == 1)
            {
                audioSource.PlayOneShot(sfxGo);
                avancement--;
            }
        }
        if (Application.isPlaying && time >= -0.2f)
        {
            Counter.text = "";
            background.SetActive(false);
            globalCanvas.SetActive(true);
            localCanvas.SetActive(true);
        }
        if (Application.isPlaying && slider.value == Timer)
        {
            this.OnNext();
        }
    }

    // Update is called once per frame
    void Update()
    {
        //Debug.Log(Time.time + " : " + Time.deltaTime + " : " + time + " : " + scale);
        time += Time.deltaTime;
        CounterChanging();
        CounterScaling();
    }

    public void SkipByNumber()
    {
        this.OnNext();
    }
}