using UnityEngine;
public enum Manager
{
    MENU,
    EXPLANATIONS,
    GAME_A,
    GAME_B,
    GAME_C,
    SCORE,
}

public class GameManager : MonoBehaviour
{
    public Manager Manager;
    public GameObject GuiMENU, GuiEXPLANATIONS, GuiGAME_A, GuiGAME_B, GuiGAME_C, GuiSCORE;
    public int[] Score = new int[3];
    static public GameManager Instance;
    [SerializeField] GameObject playerInput;

    [SerializeField] GameObject canvasGame;


    // Instanciation d'un unique GameManager
    private void Awake()
    {
       if(Instance != null) {
            Debug.LogError("Double singleton !");
       }
       else {
            Instance = this;
       }
    }

    // Utilisation des composants de Unity
    public void GetGamesComponents()
    {
        //GuiEXPLANATIONS.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
        //GuiGAME_A.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
        //GuiGAME_B.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
        //GuiGAME_C.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
    }

    // Start is called once before the first execution of Update after the MonoBehaviour is created
    void Start()
    {
        Manager = Manager.MENU;
        //GuiMENU.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
        //GuiSCORE.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
        GetGamesComponents();
    }

    // Modification de l'�tat du GameManager
    public void SetManager(Manager nextStep)
    {
        Manager = nextStep;
    }

    // Update is called once per frame
    void Update()
    {
        GuiMENU.SetActive(Manager == Manager.MENU);
        GuiSCORE.SetActive(Manager == Manager.SCORE);
        GuiEXPLANATIONS.SetActive(Manager == Manager.EXPLANATIONS);
        GuiGAME_A.SetActive(Manager == Manager.GAME_A);
        GuiGAME_B.SetActive(Manager == Manager.GAME_B);
        GuiGAME_C.SetActive(Manager == Manager.GAME_C);
        if(Manager == Manager.GAME_A || Manager == Manager.GAME_B || Manager == Manager.GAME_C) 
        {
        }
        else
        {
            canvasGame.SetActive(false);
        }
        if (Manager == Manager.GAME_A)
        {
            playerInput.GetComponent<PlayerInput>().ActionScriptRef = GuiGAME_A.GetComponent<Action_A>();
        }
        if (Manager == Manager.GAME_B)
        {
            playerInput.GetComponent<PlayerInput>().ActionScriptRef = GuiGAME_B.GetComponent<Action_B>();
        }
        if (Manager == Manager.GAME_C)
        {
            playerInput.GetComponent<PlayerInput>().ActionScriptRef = GuiGAME_C.GetComponent<Action_C>();
        }
    }
}