using UnityEngine;
public enum Explanations
{
    GAME_A,
    GAME_B,
    GAME_C
}
public class ExplanationManager : MonoBehaviour
{
    public Explanations Explanations;
    public GameObject GuiGAME_A, GuiGAME_B, GuiGAME_C;
    static public ExplanationManager Instance;
    [SerializeField] GameObject cuisineEnviro;
    [SerializeField] GameObject restoEnviro;


    // Instanciation d'un unique ExplanationManager
    private void Awake()
    {
        if (Instance != null)
        {
            Debug.LogError("Double singleton !");
        }
        else
        {
            Instance = this;
        }
    }

    // Start is called once before the first execution of Update after the MonoBehaviour is created
    void Start()
    {
        Explanations = Explanations.GAME_A;
        //GuiGAME_A.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
        //GuiGAME_B.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
        //GuiGAME_C.GetComponent<Canvas>().renderMode = RenderMode.ScreenSpaceOverlay;
    }

    // Modification de l'tat de l'ExplanationManager
    public void SetManager(Explanations nextStep)
    {
        Explanations = nextStep;
    }

    // Update is called once per frame
    void Update()
    {
        GuiGAME_A.SetActive(Explanations == Explanations.GAME_A);
        GuiGAME_B.SetActive(Explanations == Explanations.GAME_B);
        GuiGAME_C.SetActive(Explanations == Explanations.GAME_C);
        cuisineEnviro.SetActive(Explanations != Explanations.GAME_C);
        restoEnviro.SetActive(Explanations == Explanations.GAME_C);

    }
}
