using TMPro;
using UnityEngine;
using UnityEngine.EventSystems;

public class EmailController : MonoBehaviour, IPointerClickHandler
{
    private const string EmailTom = "tom.gatineau@ensam.eu";
    private const string EmailYohan = "yohan.nicolay@ensam.eu";
    private const string EmailRomain = "romain.puig@ensam.eu";
    
    public void OnPointerClick(PointerEventData eventData)
    {
        var linkIndex = TMP_TextUtilities.FindIntersectingLink(
            GetComponent<TMP_Text>(), 
            eventData.position, 
            null);
        
        var linkId = GetComponent<TMP_Text>().textInfo.linkInfo[linkIndex].GetLinkID();
        
        var email = linkId switch
        {
            "IDTom" => EmailTom,
            "IDYohan" => EmailYohan,
            "IDRomain" => EmailRomain,
            _ => null
        };
        
        if (email != null)
        {
            Application.OpenURL("mailto:" + email);
        }
    }
    
    
}
