
using NUnit.Framework;
using System.Collections.Generic;
using UnityEngine;

public enum DoughType
{
    Styling,
    Slimming,
    Healing,
    Medicinal,
    Vitaminized
}

public struct Dough
{
    public DoughType Type;
    public float IngredientQuality;
    public float CookedQuality;
    public int Quantity;

    public Dough(DoughType type, float v1, float v2)
    {
        Type = type;
        IngredientQuality = v1;
        CookedQuality = v2;
        Quantity = 4;
    }
}

public class DataStorage : MonoBehaviour
{
    public List<Dough> RawDoughList = new List<Dough>();
    public List<Dough> CookedDoughList = new List<Dough>();
    public List<float> CatSatisfaction = new List<float>();

    public float IngredientPoints;
    public float CookingPoints;
    public float ServingPoints;
    public float SatisfactionScore;


    private void Start()
    {
        //CookedDoughList.Add(new Dough(DoughType.Styling, 1f, 1f));
        //CookedDoughList.Add(new Dough(DoughType.Styling, 1f, 1f));
        //CookedDoughList.Add(new Dough(DoughType.Medicinal, 1f, 1f));
        //CookedDoughList.Add(new Dough(DoughType.Slimming, 1f, 1f));
        //CookedDoughList.Add(new Dough(DoughType.Vitaminized, 1f, 1f));
        //CookedDoughList.Add(new Dough(DoughType.Healing, 1f, 1f));

    }
}



