using NUnit.Framework;
using System.Collections.Generic;
using UnityEngine;

public class Action_C : ActionScript
{
    [SerializeField] ServeParameters serveM, serveI, serveA, serveO, serveU;
    [SerializeField] List<Dough> doughServing = new List<Dough>();
    [SerializeField] CatGenerator catRef;
    [SerializeField] GameObject prefabSpawner;
    [SerializeField] GameObject canvas;

    [SerializeField] GamesManager gamesManager;

    [Header("Audio")]
    [SerializeField] AudioSource audioSource;
    [SerializeField] AudioClip Alimentadd, RecipePerfect, RecipeMid, RecipeTrash;

    [Header("SFXs")]
    [SerializeField] GameObject sfxSpawn;
    [SerializeField] GameObject textOK, textPerfect, textTrash;


    // Start is called once before the first execution of Update after the MonoBehaviour is created
    void Start()
    {
        
    }
    void OnEnable()
    {
        canvas.SetActive(false);
        datas.CatSatisfaction.Clear();
        datas.ServingPoints = 0;
        datas.SatisfactionScore = 0;
        ServeSetUp(serveM);
        ServeSetUp(serveI);
        ServeSetUp(serveA);
        ServeSetUp(serveO);
        ServeSetUp(serveU);
    }

    public void ServeSetUp(ServeParameters serve)
    {
        serve.Quantity = 4;
        serve.Doughs.Clear();
        for (int i = 0; i < datas.CookedDoughList.Count; i++)
        {
            if (datas.CookedDoughList[i].Type == serve.DoughType)
            {
                serve.Doughs.Add(datas.CookedDoughList[i]);
            }
        }
        serve.TextNumber.text = serve.Doughs.Count.ToString();

        for (int i = 0; i < serve.quarters.Count; i++)
        {
            if (serve.Doughs.Count == 0)
            {
                serve.quarters[i].SetActive(false);
            }
            else
            {
                serve.quarters[i].SetActive(true);
            }
        }

    }

    public override void ActionM()
    {
        Action(serveM);

    }

    public override void ActionI()
    {
        Action(serveI);

    }

    public override void ActionA()
    {
        Action(serveA);

    }

    public override void ActionO()
    {
        Action(serveO);

    }

    public override void ActionU()
    {
        Action(serveU);
    }
    public override void ActionEnter() 
    {
        float satisfactionscore = 0f;
        float satisfactionData = 0f;
        Debug.Log("CatProblemsNb " + catRef.CatProblems.Count);
        for (int i = 0;i < doughServing.Count;i++)
        {
            for (int j = 0; j < catRef.CatProblems.Count; j++)
            {

                if (doughServing[i].Type == catRef.CatProblems[j])
                {
                    satisfactionscore += 1f/catRef.CatProblems.Count * doughServing[i].IngredientQuality * doughServing[i].CookedQuality;
                    satisfactionData += 1f / catRef.CatProblems.Count;
                }
            }
        }
        if (satisfactionData == 1)
        {
            audioSource.PlayOneShot(RecipePerfect);
            GameObject sfx = Instantiate(textPerfect, sfxSpawn.transform);
        }
        else if(satisfactionData > 0)
        {
            audioSource.PlayOneShot(RecipeMid);
            GameObject sfx = Instantiate(textOK, sfxSpawn.transform);
        }
        else
        {
            audioSource.PlayOneShot(RecipeTrash);
            GameObject sfx = Instantiate(textTrash, sfxSpawn.transform);
        }
        Debug.Log(satisfactionData);
        doughServing.Clear();
        datas.ServingPoints += satisfactionData * 100;
        datas.CatSatisfaction.Add(satisfactionscore);
        //catRef.gameObject.SetActive(false);
        //catRef.gameObject.SetActive(true);
        GetComponent<Animator>().SetTrigger("CatGo");
        if (serveM.Doughs.Count == 0 && serveI.Doughs.Count == 0 && serveA.Doughs.Count == 0 && serveO.Doughs.Count == 0 && serveU.Doughs.Count == 0)
        {
            gamesManager.SkipByNumber();
        }
    }

    public void Action(ServeParameters serve)
    {
        if (serve != null)
        {
            if (serve.Doughs.Count > 0)
            {
                doughServing.Add(serve.Doughs[0]);
                GameObject food = Instantiate(serve.FoodPrefab, prefabSpawner.transform.position, Quaternion.Euler(Random.Range(0, 360), Random.Range(0, 360), Random.Range(0, 360)));
                food.transform.parent = prefabSpawner.transform;
                audioSource.PlayOneShot(Alimentadd);
                if (serve.Quantity > 1)
                {
                    serve.Quantity -= 1;
                }
                else
                {
                    serve.Quantity = 4;
                    serve.Doughs.RemoveAt(0);
                    serve.TextNumber.text = serve.Doughs.Count.ToString();
                }
                for (int i = 0; i < serve.quarters.Count; i++)
                {
                    if (serve.Doughs.Count > 0)
                    {
                        if (i >= serve.Quantity)
                        {
                            serve.quarters[i].SetActive(false);
                        }
                        else
                        {
                            serve.quarters[i].SetActive(true);
                        }
                    }
                    else
                    {
                        serve.quarters[i].SetActive(false);
                    }
                }
                //for (int i = 0; i < doughServing.Count; i++)
                //{
                //    Debug.Log(doughServing[i].Type);
                //}

            }
        }
    }

}
