using System;
using System.Collections.Generic;
using UnityEngine;
using Random = UnityEngine.Random;

public enum Ingredient
{
    Fish,
    Catnip,
    Chicken,
    Cheese,
    Zucchini
}
public class Action_A : ActionScript
{
    [Header("Ingredient")]
    public List<Ingredient> RecipeStyling;
    public List<Ingredient> RecipeSlimming;
    public List<Ingredient> RecipeHealing;
    public List<Ingredient> RecipeMedicinal;
    public List<Ingredient> RecipeVitaminized;
    [Space(15)]
    
    private DoughType actualDoughtype;
    List<Ingredient> actualRecipe = new List<Ingredient>();
    List<Ingredient> actualMixture = new List<Ingredient>();
    
    

    [SerializeField] GameObject stylingRecipe, slimmingRecipe, healingRecipe, medicinalRecipe, vitaminizedRecipe;

    [SerializeField] GameObject fishPrefab, catnipPrefab, chickenPrefab, cheesePrefab, zucchiniPrefab;
    [SerializeField] GameObject prefabSpawner;
    [SerializeField] GameObject canvas;

    [Space(5)]
    [Header("Audio")]
    [SerializeField]  AudioSource audioSource;
    [SerializeField]  AudioClip Alimentadd, RecipePerfect,RecipeMid,RecipeTrash;

    [Header("Animation")]
    [SerializeField] Animator acBowl;

    [Header("SFXs")]
    [SerializeField] GameObject sfxSpawn;
    [SerializeField] GameObject textOK, textPerfect, textTrash;

    private void OnEnable()
    {
        canvas.SetActive(false);
        datas.IngredientPoints = 0;
        datas.RawDoughList.Clear();
        actualMixture.Clear();
        actualRecipe.Clear();
        NewRecipe();
    }


    public void AddInMixture(Ingredient ingredient)
    {
        actualMixture.Add(ingredient);
    }

    void ValidMixture()
    {
        int recipeIngredientCount = actualRecipe.Count;
        int ingredientQuantity = actualRecipe.Count;
        bool error = false;
        bool complete = true;

        if (actualMixture.Count > 0)
        {
            for (int i = 0; i < actualMixture.Count; i++)
            {
                if (actualRecipe.Contains(actualMixture[i]) && recipeIngredientCount > 0)
                {
                    actualRecipe.Remove(actualMixture[i]);
                    recipeIngredientCount--;
                }
                else
                {
                    if (!error)
                    {
                        if(actualMixture.Count == 1)
                        {
                            complete = false;

                        }
                        error = true;
                    }
                    else
                    {
                        complete = false;
                        break;
                    }
                }
            }
            if (Mathf.Abs(actualMixture.Count - ingredientQuantity) == 1)
            {
                if (!error)
                {
                    error = true;
                }
                else
                {
                    complete = false;
                }
            }
            else if (Mathf.Abs(actualMixture.Count - ingredientQuantity) > 1)
            {
                complete = false;
            }
        }
        else
        {
            complete = false;
        }
        if (complete)
        {
            AddStorage(actualDoughtype,error);
            if (error)
            {
                audioSource.PlayOneShot(RecipeMid);
                GameObject sfx= Instantiate(textOK, sfxSpawn.transform);
            }
            else
            {
                audioSource.PlayOneShot(RecipePerfect);
                GameObject sfx = Instantiate(textPerfect, sfxSpawn.transform);

            }
            Debug.Log("COMPLETE");
        }
        else
        {
            Debug.Log("POUBELLE");
            audioSource.PlayOneShot(RecipeTrash);
            GameObject sfx = Instantiate(textTrash, sfxSpawn.transform);

        }

        acBowl.SetTrigger("BowlGo");
        actualMixture.Clear();
        actualRecipe.Clear();
        NewRecipe();
    }

    void AddStorage(DoughType doughType, bool error)
    {
        datas.RawDoughList.Add(new Dough(doughType,error? 0.5f : 1,0));
        datas.IngredientPoints += error ? 50f : 100f;
    }
    
    void NewRecipe()
    {
        stylingRecipe.SetActive(false);
        slimmingRecipe.SetActive(false);
        healingRecipe.SetActive(false);
        medicinalRecipe.SetActive(false);
        vitaminizedRecipe.SetActive(false);
        switch (Random.Range(0,5))
        {
          case 0:
              for (int i = 0; i < RecipeStyling.Count; i++)
              {
                  actualRecipe.Add(RecipeStyling[i]);
              }
              actualDoughtype = DoughType.Styling;
                stylingRecipe.SetActive(true);

                //Debug.Log("NEW RECIPE STYLING");
                break;
          case 1:
              for (int i = 0; i < RecipeSlimming.Count; i++)
              {
                  actualRecipe.Add(RecipeSlimming[i]);
              }
              actualDoughtype = DoughType.Slimming;
                slimmingRecipe.SetActive(true);

                //Debug.Log("NEW RECIPE SLIMMING");
                break;
          case 2:
              for (int i = 0; i < RecipeHealing.Count; i++)
              {
                  actualRecipe.Add(RecipeHealing[i]);
              }
              actualDoughtype = DoughType.Healing;
                healingRecipe.SetActive(true);

                //Debug.Log("NEW RECIPE HEALING");
                break;
          case 3:
              for (int i = 0; i < RecipeMedicinal.Count; i++)
              {
                  actualRecipe.Add(RecipeMedicinal[i]);
              }
              actualDoughtype = DoughType.Medicinal;
                medicinalRecipe.SetActive(true);

                //Debug.Log("NEW RECIPE MEDICINAL");
                break;
          case 4:
              for (int i = 0; i < RecipeVitaminized.Count; i++)
              {
                  actualRecipe.Add(RecipeVitaminized[i]);
              }
              actualDoughtype = DoughType.Vitaminized;
                vitaminizedRecipe.SetActive(true);

                //Debug.Log("NEW RECIPE VITAMINIZED");
                break;
          
          default:
              break;
        }
    
    }
   
    //INPUT ACTION ____________________________________
    public override void ActionM()
    {
       AddInMixture(Ingredient.Catnip);
        GameObject catnip = Instantiate(catnipPrefab, prefabSpawner.transform.position, Quaternion.Euler(-90, Random.Range(0,360), 0));
        catnip.transform.parent = prefabSpawner.transform;
        //Debug.Log("CATNIP");
        audioSource.PlayOneShot(Alimentadd);
    }
    public override void ActionI()
    {
      AddInMixture(Ingredient.Cheese);
        GameObject cheese = Instantiate(cheesePrefab, prefabSpawner.transform.position, Quaternion.Euler(-90, Random.Range(0, 360), 0));
        cheese.transform.parent = prefabSpawner.transform;

        //Debug.Log("CHEESE");
        audioSource.PlayOneShot(Alimentadd);
    }
    public override void ActionA()
    {
        AddInMixture(Ingredient.Chicken);
        GameObject chicken = Instantiate(chickenPrefab, prefabSpawner.transform.position, Quaternion.Euler(-90, Random.Range(0,360), 0));
        chicken.transform.parent = prefabSpawner.transform;

        //Debug.Log("CHICKEN");
        audioSource.PlayOneShot(Alimentadd);
    }
    public override void ActionO()
    {
      AddInMixture(Ingredient.Fish);
        GameObject fish = Instantiate(fishPrefab, prefabSpawner.transform.position, Quaternion.Euler(-90, Random.Range(0, 360), 0));
        fish.transform.parent = prefabSpawner.transform;

        //Debug.Log("FISH");
        audioSource.PlayOneShot(Alimentadd);
    }
    public override void ActionU()
    {
       AddInMixture(Ingredient.Zucchini);
        GameObject zucchini = Instantiate(zucchiniPrefab, prefabSpawner.transform.position, Quaternion.Euler(-90, Random.Range(0, 360), 0));
        zucchini.transform.parent = prefabSpawner.transform;

        //Debug.Log("ZUCCHINI");
        audioSource.PlayOneShot(Alimentadd);
    }
    public override void ActionEnter()
    {
        //print("Enter");
        ValidMixture();
    }
}