﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[System.Serializable]
public struct Apparence
{
	[SerializeField]	private CAT_LEGENDARY legendary;
	[SerializeField]	private CAT_COLOR color;				// Couleur de la tache
	[SerializeField]	private CAT_EYES_COLOR eyesColor;		// Couleur des yeux
	[SerializeField]	private CAT_TRUFFE_COLOR truffeColor;	// Couleur de la truffe et des oreilles
	
	[SerializeField]	private float shapeAlpha;
	[SerializeField]	private CAT_ZONE zone;
	[SerializeField]	private CAT_SHAPE shape;
	[SerializeField]	private float baseRatio;				// Pourcentage de blanc de la base
	[SerializeField]	private Texture2D textureZone;

	[SerializeField]	private int tail;
	[SerializeField]	private bool male;

	[SerializeField]	private float morpho;  //-1.0 skinny -> 1.0 Fat 

	public static Apparence white
	{
		get
		{
			return new Apparence();
		}
	}

	public int Tail
	{
		get
		{
			return tail;
		}
		set
		{
			tail = value;
		}
	}

	public bool Male
	{
		get
		{
			return male;
		}
		set
		{
			male = value;
		}
	}

	public CAT_COLOR Color
	{
		get
		{
			return color;
		}
		set
		{
			color = value;
			Verify();
		}
	}

	public CAT_EYES_COLOR EyesColor
	{
		get
		{
			return eyesColor;
		}
		set
		{
			eyesColor = value;
		}
	}

	public CAT_TRUFFE_COLOR TruffeColor
	{
		get
		{
			return truffeColor;
		}
		set
		{
			truffeColor = value;
		}
	}

	public float ShapeAlpha
	{
		get
		{
			return shapeAlpha;
		}
		set
		{
			shapeAlpha = value;
		}
	}
	public float BaseRatio
	{
		get
		{
			return baseRatio;
		}
		set
		{
			baseRatio = value;
		}
	}

	public CAT_SHAPE Shape
	{
		get
		{
			return shape;
		}
		set
		{
			shape = value;
		}
	}

	public CAT_ZONE Zone
	{
		get
		{
			return zone;
		}
		set
		{
			zone = value;
		}
	}


	public float Morpho
	{
		get
		{
			return morpho;
		}
		set
		{
			morpho = value;
		}
	}

	public bool IsNotWhite
	{
		get
		{
			return false;
		}
	}

	//---------------------------------------------------------------------------------------------

	public Apparence(CAT_COLOR color)
	{
		this.color = color;
		legendary = CAT_LEGENDARY.NONE;
		shapeAlpha = 1.0f;
		shape = 0;
		male = true;
		zone = CAT_ZONE.NONE;
		textureZone = null;
		truffeColor = 0;
		eyesColor = 0;
		baseRatio = 0;
		tail = 0;
		morpho = 0.0f;
	}

	//---------------------------------------------------------------------------------------------

	public void Reset()
	{
		color = 0;
		shapeAlpha = 1.0f;
		shape = 0;
		textureZone = null;
		truffeColor = 0;
		baseRatio = 0;
		tail = 0;
		morpho = 0.0f;
	}


	//---------------------------------------------------------------------------------------------

	public Apparence(CAT_COLOR color, CAT_COLOR shapeColor, CAT_SHAPE shape)
	{
		this.color = color;
		this.textureZone = null;
		this.shape = shape = 0;

		legendary = CAT_LEGENDARY.NONE;
		shapeAlpha = 1.0f;
		zone = CAT_ZONE.NONE;
		textureZone = null;
		truffeColor = 0;
		eyesColor = 0;
		baseRatio = 0;
		male = true;
		tail = 0;
		morpho = 0.0f;		
	}

	//---------------------------------------------------------------------------------------------

	public Apparence(CAT_SHAPE shape)
	{
		if (shape == CAT_SHAPE.LEGENDARY)
		{
			Apparence apparence = new Apparence();
			this.textureZone = null;			
			this.shape = apparence.shape;
			legendary = CAT_LEGENDARY.NONE;
			color = apparence.color;
			male = true;
			zone = CAT_ZONE.NONE;
			baseRatio = apparence.baseRatio;
			truffeColor = apparence.truffeColor;
			eyesColor = apparence.eyesColor;
			shapeAlpha = apparence.shapeAlpha;
			tail = apparence.tail;
			morpho = apparence.morpho;
		}
		else
		{
			color = Apparence.GetRandomColor();
			legendary = CAT_LEGENDARY.NONE;
			shapeAlpha = 1.0f;
			this.shape = 0;
			male = true;
			textureZone = null;
			zone = CAT_ZONE.NONE;
			truffeColor = 0;
			eyesColor = 0;
			baseRatio = 0;
			tail = 0;
			morpho = 0.0f;
		}
	}

	//---------------------------------------------------------------------------------------------

	public Apparence(Apparence papa, Apparence maman, bool pure)
	{
		color = Apparence.GetRandomColor();
		legendary = CAT_LEGENDARY.NONE;
		shapeAlpha = 1.0f;
		shape = 0;
		male = true;
		textureZone = null;
		truffeColor = 0;
		eyesColor = 0;
		baseRatio = 0;
		zone = CAT_ZONE.NONE;
		tail = 0;
		morpho = 0.0f;

		// Colors ---------------------------------------------------------------------------------

		if (papa.IsLegendary && maman.IsLegendary)
		{
			this = Apparence.GetRandom();
			return;
		}

		if (papa.IsLegendary)
		{
			this = maman;
			return;
		}

		if (maman.IsLegendary)
		{
			this = papa;
			return;
		}
		
		if (Random.value < 0.05f && !pure)
		{
			// 5% random multi colored

			List<CAT_COLOR> colors = new List<CAT_COLOR>();
			List<CAT_SHAPE> shapes = new List<CAT_SHAPE>();

			colors.Add(papa.color);
			colors.Add(maman.color);			
		}
		else
		{
			color = Fusion(papa.color, maman.color);

			//if (papa.shape == CAT_SHAPE.NONE && maman.shape == CAT_SHAPE.NONE)
			//{
			//	shape = CAT_SHAPE.NONE;
			//	shapeColor = 0;
			//}
			//else if (papa.shape != CAT_SHAPE.NONE && maman.shape == CAT_SHAPE.NONE)
			//{
			//	shape = papa.shape;
			//	shapeColor = papa.shapeColor;
			//}
			//else if (papa.shape == CAT_SHAPE.NONE)
			//{
			//	shape = maman.shape;
			//	shapeColor = maman.shapeColor;
			//}
			//else
			//{
			//	shape = Random.value > 0.5f ? maman.shape : papa.shape;
			//	shapeColor = Fusion(papa.shapeColor, maman.shapeColor);
			//}
		}

		//if (shapeColor == color)
		//{
		//	shape = CAT_SHAPE.NONE;
		//	shapeColor = 0;
		//}
	}

	static List<CAT_COLOR> colors = null;
	static List<CAT_COLOR> colorsbutWhite = null;
	static List<CAT_SHAPE> shapes = null;
	static List<CAT_ZONE> zones= null;

	//------------------------------------------------------------------------------------------------
	public void Randomize(bool linear = false)
	{
		if (colorsbutWhite == null)
		{
			colorsbutWhite = new List<CAT_COLOR>();
			for (CAT_COLOR i = (CAT_COLOR)1; i < CAT_COLOR.COUNT; i++)
			{
				colorsbutWhite.Add(i);
			}
		}

		if (colors == null)
		{
			colors = new List<CAT_COLOR>();
			for (CAT_COLOR i = 0; i < CAT_COLOR.COUNT; i++)
			{
				colors.Add(i);
			}
		}

		if (zones == null)
		{
			zones = new List<CAT_ZONE>();
			for (CAT_ZONE i = 0; i < CAT_ZONE.COUNT; i++)
			{
				zones.Add(i);
			}
		}
		if (shapes == null)
		{
			shapes = new List<CAT_SHAPE>();
			for (CAT_SHAPE i = 0; i < CAT_SHAPE.COUNT; i++)
			{
				shapes.Add(i);
			}
		}

		textureZone = null;
		legendary = CAT_LEGENDARY.NONE;

		if (linear)
		{
			color = (CAT_COLOR)Random.Range(0, (int)(CAT_COLOR.COUNT));
			shape = (CAT_SHAPE)Random.Range(0, (int)CAT_SHAPE.COUNT);
			zone = (CAT_ZONE)Random.Range(0, (int)CAT_ZONE.COUNT);
		}
		else
		{
			color = colorsbutWhite.RandomPow(0.25f);
			shape = shapes.RandomPow(0.4f);
			zone = zones.RandomPow(0.3f);
		}

		shapeAlpha = Mathf.Pow(Random.Range(0.25f, 1.0f), 2.0f);
		baseRatio = Random.Range(0.5f, 1.0f);
		truffeColor = (CAT_TRUFFE_COLOR)Random.Range(0, (int)CAT_TRUFFE_COLOR.COUNT);
		eyesColor = (CAT_EYES_COLOR)Random.Range(0, (int)CAT_EYES_COLOR.COUNT);

		tail = Random.Range(0, 4);
		male = (Random.value > 0.5f);
		morpho = Random.Range(-1.0f, 1.0f);
	}

	//------------------------------------------------------------------------------------------------

	public bool IsLegendary => legendary > CAT_LEGENDARY.NONE && legendary < CAT_LEGENDARY.COUNT;
	
	//------------------------------------------------------------------------------------------------

	public bool HasBlack()
	{
		return false;
	}

	//------------------------------------------------------------------------------------------------

	public bool Is(CAT_COLOR color)
	{
		return true; // this.color == color && shape == CAT_SHAPE.NONE;
	}

	//---------------------------------------------------------------------------------------------

	public static bool Valid(Apparence apparence)
	{
		return true; // Valid(apparence.color, apparence.shapeColor, apparence.shape);
	}

	//---------------------------------------------------------------------------------------------

	public static bool Valid(CAT_COLOR color, CAT_COLOR shapeColor, CAT_SHAPE shape)
	{
		if (shape >= CAT_SHAPE.COUNT)
		{
			return false;
		}

		if (shape != CAT_SHAPE.NONE && shape != CAT_SHAPE.LEGENDARY && shapeColor == color)
		{
			return false;
		}

		if (shape == CAT_SHAPE.LEGENDARY && color <= CAT_COLOR.COUNT)
		{
			return false;
		}

		return true;
	}

	//---------------------------------------------------------------------------------------------

	public Material Affect2DMaterial(Material material = null)
	{
		if (IsLegendary)
		{
			/*material = material ?? new Material(Interface.Instance.spriteMaterial);

			material.color = UnityEngine.Color.white;
			material.SetColor("_ShapeColor", UnityEngine.Color.white);

			Sprite sprite = GetSprite();
			if (sprite != null)
			{
				material.SetTexture("_MainTex", sprite.texture);
				material.SetTexture("_ShapeTex", null);
			}*/

			return null;
		}
		else
		{
			material = material ?? new Material(Interface.Instance.rabbit2DMaterial);

			material.color = Cat.GetColor(Color);

			if (Shape != CAT_SHAPE.INVALID && Shape != CAT_SHAPE.NONE)
			{
				//material.SetColor("_ShapeColor", Cat.GetColor(BaseColor));
				material.SetFloat("_BaseRatio", BaseRatio);
				material.SetTexture("_ShapeTex", null);
				material.SetTextureOffset("_ShapeTex", new Vector2(Random.value, Random.value));
			}
			else
			{
				material.SetTexture("_ShapeTex", null);
				material.SetFloat("_BaseRatio", BaseRatio);
				material.SetColor("_ShapeColor", Cat.GetColor(Color));
			}

		}
		
		return material;
	}

	//---------------------------------------------------------------------------------------------

	public Material AffectMaterial(Material material = null)
	{
        if (material == null)
        {
	        material = new Material(Interface.Instance.rabbitMaterial);
        }

		//if (IsLegendary)
		//{
		//	switch (Color)
		//	{
		//		case CAT_COLOR.SPECIAL_FIRE:
		//		{
		//			material.color = new Color(1.0f, 0.0f, 0.0f, 1.0f);
		//			material.SetColor("_ShapeColor", new Color(1.0f, 0.7f, 0.0f, 1.0f));

		//			material.SetTexture("_ShapeTex", Interface.Instance.GetTextureShapeFull(CAT_SHAPE.VORTEX).texture);
		//			material.SetTextureOffset("_ShapeTex", new Vector2(4.0f, 4.0f));
		//			material.SetTextureScale("_ShapeTex", new Vector2(4.0f, 4.0f));
		//			material.SetVector("_Moving", new Vector2(10.0f, 10.0f));
		//			break;
		//		}
		//	}
		//}
		//else
		{
			// Set color

			material.color = Cat.GetColor(Color);

			if (Shape != CAT_SHAPE.INVALID && Shape != CAT_SHAPE.NONE)
			{
				material.SetFloat("_BaseRatio", BaseRatio);
				material.SetTexture("_TexShape", Interface.Instance.GetShapeTexture(Shape));
				material.SetTexture("_ZoneShape", Interface.Instance.GetZoneTexture(zone));
				material.SetFloat("_ShapeAlpha", ShapeAlpha);				
			}
			else
			{
				material.SetFloat("_ShapeAlpha", 0.0f);
				material.SetFloat("_BaseRatio", BaseRatio);
				material.SetTexture("_TexShape", null);
				material.SetTexture("_ZoneShape", Interface.Instance.GetZoneTexture(zone));
			}
		}
		return material;
	}

	//---------------------------------------------------------------------------------------------

	public void Set(CAT_COLOR color, CAT_COLOR shapeColor, CAT_SHAPE shape)
	{
		this.color = color;
		//this.shapeColor = shapeColor;
		this.shape = shape;

		Verify();
	}

	//---------------------------------------------------------------------------------------------

	public static CAT_COLOR GetRandomColor(bool linear = false)
	{
		if (linear)
		{
			return (CAT_COLOR)(Random.Range(0, (int)CAT_COLOR.COUNT));
		}
		else
		{
			return (CAT_COLOR)(Mathf.Pow(Random.value, 2.0f) * (float)CAT_COLOR.COUNT);
		}
	}

	//---------------------------------------------------------------------------------------------

	public static CAT_SHAPE GetRandomShape(bool linear = false)
	{
		if (linear)
		{
			return (CAT_SHAPE)(Random.Range(1, (int)CAT_SHAPE.LEGENDARY));
		}
		else
		{
			return (CAT_SHAPE)(Mathf.Pow(Random.value, 2.0f) * (float)CAT_SHAPE.LEGENDARY);
		}
	}

	//---------------------------------------------------------------------------------------------

	public static CAT_COLOR GetRandomColorBut(CAT_COLOR except)
	{
		CAT_COLOR color = (CAT_COLOR)(Random.Range(0, (int)CAT_COLOR.BLACK - 1));

		if (color == except) color++;
		return color;
	}

	//---------------------------------------------------------------------------------------------

	/*public static CAT_SHAPE GetRandomShape(bool linear = false)
	{
		int nbUnlocked;

		if (linear)
		{
			nbUnlocked = Random.Range(0, Data.numberOfUnlockedShapes);
		}
		else
		{
			nbUnlocked = (int) (Mathf.Pow(Random.value, 8.0f) * (float)Data.numberOfUnlockedShapes);
		}

		for (CAT_SHAPE shape = 0; shape < CAT_SHAPE.COUNT; shape++)
		{
			if (Data.Instance.IsUnlocked(shape))
			{
				if (nbUnlocked-- <= 0)
				{
					return shape;
				}
			}
		}

		Debug.LogError("Apparence.GetRandomShape(" + linear + ") " + nbUnlocked);
		return CAT_SHAPE.INVALID;
	}*/

	//---------------------------------------------------------------------------------------------

	public static Apparence GetRandom(bool linear = false)
	{
		Apparence apparence = new();
		apparence.Randomize(linear);		

		return apparence;
	}

	//---------------------------------------------------------------------------------------------

	public static Apparence GetRandom(Apparence forbidden)
	{
		Apparence apparence = new Apparence
		{
			shape = CAT_SHAPE.SQUARE,
			color = GetRandomColor(true)
		};

		//if (apparence.shape != CAT_SHAPE.NONE)
		//{
		//	apparence.shapeColor = GetRandomColorBut(apparence.color);
		//}
		//else
		//{
		//	apparence.shapeColor = 0;
		//}

		if (apparence == forbidden)
		{
			apparence.Color = (CAT_COLOR) (((int)apparence.Color + Random.Range(1, (int)CAT_COLOR.COUNT)) % (int)CAT_COLOR.COUNT);
		}

		return apparence;
	}

	//---------------------------------------------------------------------------------------------

	public static Apparence GetRandom(CAT_SHAPE shape, Apparence forbidden)
	{
		Apparence apparence = new Apparence
		{
			shape = shape,
			color = GetRandomColor(true)
		};

		//if (apparence.shape != CAT_SHAPE.NONE)
		//{
		//	apparence.shapeColor = GetRandomColorBut(apparence.color);
		//}
		//else
		//{
		//	apparence.shapeColor = 0;
		//}

		if (apparence == forbidden)
		{
			apparence.Color = (CAT_COLOR)(((int)apparence.Color + Random.Range(1, (int)CAT_COLOR.COUNT)) % (int)CAT_COLOR.COUNT);
		}

		return apparence;
	}

	//---------------------------------------------------------------------------------------------

	public static Apparence GetRandom(CAT_SHAPE shape)
	{
		Apparence apparence = new Apparence
		{
			shape = shape,
			color = GetRandomColor(true)
		};

		//if (apparence.shape != CAT_SHAPE.NONE)
		//{
		//	apparence.shapeColor = GetRandomColorBut(apparence.color);
		//}
		//else
		//{
		//	apparence.shapeColor = 0;
		//}

		return apparence;
	}

	//---------------------------------------------------------------------------------------------

	public void Inverse()
	{
		// Lolipop effect

		//if (shape != CAT_SHAPE.NONE)
		//{
		//	CAT_COLOR tmp = color;
		//	color = baseColor;
		//	baseColor = tmp;
		//}
	}

	//---------------------------------------------------------------------------------------------

	public override string ToString()
	{
		if (shape == CAT_SHAPE.NONE || shape == CAT_SHAPE.LEGENDARY)
		{
			return color.ToString();
		}
		else 
		{
			return "[Apparence " + color.ToString() + ", " + shapeAlpha + ", " + shape + ", " + eyesColor + "]";
		}
	}

	//---------------------------------------------------------------------------------------------

	public int Price(bool sell = false)
	{
		int s = (int)shape;
		int sc = (int)shapeAlpha * 10;

		if (shape == CAT_SHAPE.INVALID)
		{
			s = 0;
		}

		if (shape == CAT_SHAPE.NONE)
		{
			sc = 0;
			s = 1;
		}
		else
		{
			s += 2;
		}


		if (shape == CAT_SHAPE.LEGENDARY)
		{
			s += 50;
		}

		int price = (color > CAT_COLOR.YELLOW_BANANA ? 2 : 1) * (2 + (sc + (int)color) / 2 + s*20);

		if (sell)
		{
			//return (int)(price * Prices.Instance.ratioSell);
		}
		else
		{
			//return (int) (price * Auras.promotions);
		}

		return 0;
	}

	//---------------------------------------------------------------------------------------------

	public override bool Equals(object obj)
	{
		if (!(obj is Apparence))
		{
			return false;
		}

		var apparence = (Apparence)obj;
		return color == apparence.color &&
			   shape == apparence.shape &&
			   (shape == CAT_SHAPE.NONE || shapeAlpha == 0);
	}

	//---------------------------------------------------------------------------------------------

	public override int GetHashCode()
	{
		var hashCode = -643383977;
		hashCode = hashCode * -1521134295 + color.GetHashCode();
		hashCode = hashCode * -1521134295 + shape.GetHashCode();
		if (shape != CAT_SHAPE.NONE)
		{
			hashCode = hashCode * -1521134295 + shapeAlpha.GetHashCode();
		}
		return hashCode;
	}

	//---------------------------------------------------------------------------------------------

	public static bool operator ==(Apparence per1, Apparence per2)
	{
		return per1.color == per2.color &&
			   per1.shape == per2.shape &&
			   (per1.shape == CAT_SHAPE.NONE || per1.baseRatio == per2.baseRatio);
	}

	//---------------------------------------------------------------------------------------------

	public static bool operator !=(Apparence per1, Apparence per2)
	{
		return per1.color != per2.color ||
			   per1.shape != per2.shape ||
			   (per1.baseRatio != per2.baseRatio && per1.shape != CAT_SHAPE.NONE);
	}

	//---------------------------------------------------------------------------------------------

	public Sprite GetSprite()
	{
		/*if (IsLegendary())
		{
			return Legendary.Instance.GetSprite(Color);
		}*/

		return Interface.Instance.rabbitIcon;
	}

	//---------------------------------------------------------------------------------------------

	public static Apparence GetNewApparence(CAT_SHAPE shape)
	{
		if (shape == CAT_SHAPE.NONE)
		{
			return new Apparence(CAT_COLOR.SNOW_QUEEN);
		}

		CAT_COLOR newColor = (CAT_COLOR)(((int)shape - 1) % (int)CAT_COLOR.COUNT);
		CAT_COLOR newShapeColor = (CAT_COLOR)(((int)shape) % (int)CAT_COLOR.COUNT);
		return new Apparence(newColor, newShapeColor, shape);
	}

	//---------------------------------------------------------------------------------------------

	public static CAT_COLOR Rnd(CAT_COLOR color1, CAT_COLOR color2) => UnityEngine.Random.value > 0.5f ? color1 : color2;

	//---------------------------------------------------------------------------------------------

	public static CAT_COLOR Fusion(CAT_COLOR color1, CAT_COLOR color2)
	{
		if (color1 == CAT_COLOR.BLACK || color2 == CAT_COLOR.BLACK)
		{
			return CAT_COLOR.BLACK;
		}
		if (color1 == color2)
		{
			return color1;
		}

		if (color1 > color2)
		{
			CAT_COLOR tmp = color1;
			color1 = color2;
			color2 = tmp;
		}

		/*switch (color1)
		{
			case CAT_COLOR.SNOW_QUEEN:
			{
				switch (color2)
				{
					case CAT_COLOR.RED: return CAT_COLOR.PINK;
					case CAT_COLOR.BLUE: return CAT_COLOR.CYAN;
				}
				return color2;
			}
			case CAT_COLOR.RED:
			{
				switch (color2)
				{
					case CAT_COLOR.BLUE: return CAT_COLOR.PURPLE;
					case CAT_COLOR.YELLOW: return CAT_COLOR.ORANGE;
					//case CAT_COLOR.GREEN: 
					case CAT_COLOR.CYAN: return CAT_COLOR.PURPLE;
					case CAT_COLOR.PINK: return CAT_COLOR.RED;
					//case CAT_COLOR.PURPLE: 
					case CAT_COLOR.ORANGE: return CAT_COLOR.RED;
				}
				break;
			}
			case CAT_COLOR.BLUE:
				switch (color2)
				{
					case CAT_COLOR.YELLOW: return CAT_COLOR.GREEN;
					// case CAT_COLOR.GREEN
					case CAT_COLOR.CYAN: return CAT_COLOR.BLUE;
					case CAT_COLOR.PINK: return CAT_COLOR.PURPLE;
					case CAT_COLOR.PURPLE: return CAT_COLOR.PURPLE;
					//case CAT_COLOR.ORANGE
				}
				break;
			case CAT_COLOR.YELLOW:
				switch (color2)
				{
					case CAT_COLOR.GREEN: return CAT_COLOR.GREEN;
					case CAT_COLOR.CYAN: return CAT_COLOR.GREEN;
					case CAT_COLOR.PINK: return CAT_COLOR.ORANGE;
					// case CAT_COLOR.PURPLE
					case CAT_COLOR.ORANGE: return CAT_COLOR.ORANGE;
				}
				break;
			case CAT_COLOR.GREEN:
				switch (color2)
				{
					case CAT_COLOR.CYAN: return CAT_COLOR.BLUE;
					// case CAT_COLOR.PINK
					// case CAT_COLOR.PURPLE
					// case CAT_COLOR.ORANGE
				}
				break;
			case CAT_COLOR.CYAN:
				switch (color2)
				{
					case CAT_COLOR.PINK: return CAT_COLOR.PURPLE;
					case CAT_COLOR.PURPLE: return CAT_COLOR.PURPLE;
						// case CAT_COLOR.ORANGE
				}
				break;
			case CAT_COLOR.PINK:
				switch (color2)
				{
					case CAT_COLOR.PURPLE: return CAT_COLOR.PURPLE;
				}
				break;

		}*/

		//return CAT_COLOR.INVALID;
		return Rnd(color1, color2);
	}


	//---------------------------------------------------------------------------------------------

	public void Verify()
	{
		//if (shape >= CAT_SHAPE.COUNT || (shape != CAT_SHAPE.NONE && color == baseColor))
		//{
		//	//Debug.LogWarning("invalid " + ToString());
		//	shape = CAT_SHAPE.NONE;
		//	baseColor = 0;
		//}
		//else if (shape == CAT_SHAPE.NONE || shape == CAT_SHAPE.LEGENDARY)
		//{
		//	baseColor = 0;
		//}				
	}

	//---------------------------------------------------------------------------------------------
}