﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityStandardAssets.Characters.ThirdPerson;

public class MovementEnemy : MonoBehaviour
{
    public ThirdPersonCharacter heros;
    
    private Life life;

    public float speed = 1.0f;

    private float startTime;

    void Start()
    {
        heros = FindObjectOfType<ThirdPersonCharacter>();
        life = heros.GetComponent<Life>();
        startTime = 0.0f;
    }

    // Update is called once per frame
    void Update()
    {
        if (heros != null)
        {
            Vector3 direction = transform.position - heros.transform.position;

            direction.y = 0.0f;

            transform.Translate(- direction.normalized * Time.deltaTime * speed);

            // Phase d'attaque du monstre
            if (direction.magnitude < 1.0f && startTime + life.GetInvulnerability() <= Time.time)
            {
                startTime = Time.time;
                life.SetHealth(-4);
            }
          
        }
    }
    private void OnCollisionEnter(Collision collision)
    {
        if (collision.transform.tag == "Ammo")
        {
            Destroy(gameObject);
            Destroy(collision.gameObject);
        }
        if (collision.transform.tag == "Death")
        {
            Destroy(gameObject);
        }    
    }

    /*private void OnCollisionStay(Collision collision)
    {
        if (collision.transform.tag == "Heros" && startTime + invulnerability <= Time.time)
        {
            life.SetHealth(-4);
            startTime = Time.time;
        }
    }
    */
}
