﻿using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;
using UnityEngine.UI;



public class ManagerGame : MonoBehaviour
{
    private int waveNb = 1;
    private int fragNb = 0;

    public GameObject prefab;
    [SerializeField]
    List<GameObject> listEnemy = new List<GameObject>();
    [SerializeField]
    private TMP_Text waveNumber;

    void Start()
    {
        SpawnWave();
    }

    void Update()
    {
        waveNumber.text = waveNb.ToString(); // Refresh du texte des waves

        for (int i = 0; i < listEnemy.Count; i++)
        {
            if (listEnemy[i].gameObject == null)
            {
                listEnemy.RemoveAt(i); // Enlève la case mémoire à un index i
                fragNb++;
            }
        }
    
        if (listEnemy.Count < 1)
        {
            SpawnWave();
            waveNb++;
        }
    }

    void SpawnWave()
    {
        int amount = Random.Range(1, 10);
        for (int i = 0; i < amount; i++)
        {
            listEnemy.Add(SpawnCube());
        }
    }

    GameObject SpawnCube()
    {
        Vector3 coord = new Vector3(Random.Range(-4, 4), 0.5f, Random.Range(-4, 4)); //prefab est assigné sur Unity
        GameObject result = Instantiate(prefab, coord, Quaternion.identity, null); // On utilise la fonction "Instantiate" d'Unity pour faire apparaître le gameobject prefab (à une position donnée)
        return result;
    }
}
