﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class StateMachine : MonoBehaviour
{

    public enum State
    {
        MENU,
        GAME,
        SCORE,
        LOSE,
    }
    public int currentLevel = 1;
    public int score = 0;

    public GameObject guiMenu;
    public GameObject guiMainMenu;
    public GameObject guiScore;
    public GameObject guiLose;
    public GameObject guiLevelSelect;
    public GameObject guiCredits;
    public GameObject guiInGame;
    public GameObject guiHelp;

    public string levelName;
    public bool levelCompleted, quitMenu, levelLost;

    public LifeSystem lS;
    public Player player;
    public ScoreCount sC;
    public mapManagement mM;
    static public StateMachine instance;  //singleton
    public State state;

    void Awake()
    {
        if (instance != null) Debug.LogError("Double singleton!");
        instance = this;
    }

    void Start()
    {
        guiMainMenu.SetActive(true);
        //guiInGame.SetActive(true);

    }

    void Update()
    {
        if(Input.GetKeyDown(KeyCode.Escape))
        {
            //state = State.MENU;
            guiMenu.SetActive(true);
        }

        if(levelCompleted && !guiScore.activeSelf)
        {
            player.VictoryDance();
            //state = State.SCORE;
            sC.DisplayScore();
            guiScore.SetActive(true) ;
        }

        if (quitMenu)
        {
            guiMenu.SetActive(false);
            guiScore.SetActive(false);
            guiLose.SetActive(false);
            guiLevelSelect.SetActive(false);
            quitMenu = false;
        }

        if (levelLost && !guiLose.activeSelf)
        { 
            guiLose.SetActive(true);
        }
    }

    public void RestartLevel()
    {
        levelCompleted = false;
        lS.lifePoints = 3;
        for (int i=0; i<lS.hearts.Length;i++)
        {
            lS.hearts[i].SetActive(true);
        }
        player.BackToInitialPoint();
        score = 0;
        state = State.GAME;
        levelLost = false;
        player.ResetAnimStates();
        mM.ResetCollectibles(currentLevel);
        CloseAllMenus();
        guiInGame.SetActive(true);
        sC.diamondCatched = 0;
        //levelName = "Level" + currentLevel.ToString();
        //SceneManager.LoadScene(levelName);
    }

    public void LoadLevel()
    {
        guiLevelSelect.SetActive(false);
        levelCompleted = false;
        levelName = "Level" + currentLevel.ToString();
        SceneManager.LoadScene(levelName);
    }

    public void closeMenu()
    {
        state = State.GAME;
        quitMenu = true;
    }

    public void ChoseLevel()
    {
        levelLost = false;
        levelCompleted = false;
        CloseAllMenus();
        guiLevelSelect.SetActive(true);
    }

    public void DisplayCredits()
    {
        guiCredits.SetActive(true);
    }

    public void OpenMainMenu()
    {
        CloseAllMenus();
        guiMainMenu.SetActive(true);
    }

    public void CloseAllMenus()
    {
        guiScore.SetActive(false);
        guiLose.SetActive(false);
        guiLevelSelect.SetActive(false);
        guiCredits.SetActive(false);
        guiMainMenu.SetActive(false) ;
        guiMenu.SetActive(false) ;
    }



    public void StartLevel(int levelNumber)
    {
        currentLevel = levelNumber;
        player.ResetAnimStates();
        mM.ResetLevel(levelNumber);
        mM.ResetCollectibles(currentLevel);
        CloseAllMenus();
        RestartLevel();
        sC.diamondCatched = 0;
    }

    public void Help()
    {
        guiHelp.SetActive(true);
    }

    public void closeHelp()
    {
        guiHelp.SetActive(false);
    }





}
