﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Player : MonoBehaviour
{
    public Vector3 target, direction;
    public float x=0, z=0;
    public float speed = 10f, aSpeed = 2f, minDist = 0.1f;
    public int reverse = -1;
    public mapManagement mM;
    public Animator character;
    public StateMachine sM;
    public bool motionOver;
    // Start is called before the first frame update
    void Start()
    {
        character = GetComponentInChildren<Animator>();
    }

    Vector3 previousPosition;

    // Update is called once per frame
    void FixedUpdate()
    {

        if (Input.GetKey(KeyCode.RightArrow) && motionOver && !sM.levelLost && !sM.levelCompleted)
        {
            if (!mM.unreachableCoord.Contains(1000 * x + (z - 2)))
            {
                z -= 2;
                transform.rotation = Quaternion.Euler(0, 90, 0);
            }
        }

        else if (Input.GetKey(KeyCode.LeftArrow) && motionOver && !sM.levelLost && !sM.levelCompleted)
        {
            if (!mM.unreachableCoord.Contains(1000 * x + (z + 2)))
            {
                z += 2;
                transform.rotation = Quaternion.Euler(0, -90, 0);
            }
        }

        else if (Input.GetKey(KeyCode.UpArrow) && motionOver && !sM.levelLost && !sM.levelCompleted)
        {
            if (!mM.unreachableCoord.Contains(1000 * (x + 2) + z))
            {
                x += 2;
                transform.rotation = Quaternion.Euler(0, 0, 0);
            }
        }

        else if (Input.GetKey(KeyCode.DownArrow) && motionOver && !sM.levelLost && !sM.levelCompleted)
        {
            if (!mM.unreachableCoord.Contains(1000 * (x - 2) + z))
            {
                x -= 2;
                transform.rotation = Quaternion.Euler(0, 180, 0);
            }
        }

        //else if (Input.GetKey(KeyCode.Space) && motionOver)
        //    if (!uC.unreachableCoord.Contains(1000 * (x +4) + z))
        //    {
        //        speed = 20;
        //        x += 4;
        //        transform.rotation = Quaternion.Euler(0,0, 0);
        //    }


        target = new Vector3(x, 0.5f, z);
        float distance = (transform.position - target).magnitude;

        if (distance > minDist)
        {
            character.SetBool("walking", true);
            motionOver = false;
            aSpeed = 6.5f;
        }
        else if (!motionOver)
        {
            motionOver = true;
            character.SetBool("walking", false);
            aSpeed = 1.5f;
        }

        transform.position = Vector3.MoveTowards(transform.position, target, speed * Time.deltaTime/2f);
        previousPosition = transform.position;
        //if (speed == 20)
        //{
        //    speed = 7f;
        //}
        character.speed = aSpeed;
    }

    public void BackToInitialPoint()
    {
        x=0;
        z = 0;
        transform.position = new Vector3(0, 0.5f, 0);
        if(character.GetBool("dead"))
        {
            character.SetBool("dead", false);
        }
    }

    public void VictoryDance()
    {
        character.SetBool("victory", true);
    }

    public void ResetAnimStates()
    {
        foreach (AnimatorControllerParameter param in character.parameters)
        {
            character.SetBool(param.name, false);
        }
    }
}
