﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public enum State
{
    MENU,
    NIVEAU,
    RULES,
    CREDITS,
    VICTORY,
    DEFEAT

}

public class StateMachine : MonoBehaviour
{
    public State state;
    public GameObject Menu;
    public GameObject Rules;
    public GameObject Credits;
    public GameObject Victory, Victory1, Victory2;
    public GameObject Defeat;
    public GameObject Niveau;
    public GameObject elementsNiveau1;
    public GameObject FPS;
    public GameObject[] CratesList;
    public GameObject crateLogo;
    public GameObject[] RobotsList;
    public GameObject robotLogo;
    public GameObject boutonNiveau1;
    public GameObject boutonNiveau2, sciFiHandGun;
    public bool defeat;
    float timer;
    Vector3 originalPosition;
    public int caissesramassees, robotstues, level;

    static public StateMachine instance;  //singleton

    void Awake()
    {
        if (instance != null) Debug.LogError("Double singleton!");
        instance = this;
        originalPosition = FPS.transform.position;
        Niveau.SetActive(false);
    }

    void Start()
    {
        state = State.MENU;
        defeat = false;
    }

    void Update()
    {
        Menu.SetActive(state == State.MENU);
        Niveau.SetActive(state == State.NIVEAU);
        Credits.SetActive(state == State.CREDITS);
        Rules.SetActive(state == State.RULES);
        Victory.SetActive(state == State.VICTORY);
        Defeat.SetActive(state == State.DEFEAT);

        if (state == State.NIVEAU)
        {
            if (caissesramassees == 3 || robotstues == 3)
            {
                FPS.SetActive(false);
                Cursor.lockState = CursorLockMode.None;
                Cursor.visible = true;
                SetState(State.VICTORY);
                if (level == 1)
                {
                    Victory1.SetActive(true);
                    Victory2.SetActive(false);
                    boutonNiveau1.transform.position = new Vector3 (610f, 540f, 0f);
                    boutonNiveau2.SetActive(true);

                }
                else
                {
                    Victory1.SetActive(false);
                    Victory2.SetActive(true);
                }
            }


            else if (defeat)
            {
                if (timer == 0)
                {
                    timer = Time.time;
                }
                else if (Time.time > timer + 1.0f)
                {
                    FPS.SetActive(false);
                    Cursor.lockState = CursorLockMode.None;
                    Cursor.visible = true;
                    if (level == 1)
                    {
                        foreach (GameObject crate in CratesList)
                        {
                            crate.SetActive(true);
                        }
                    }
                    else if (level == 2)
                    {
                        foreach (GameObject robot in RobotsList)
                        {
                            robot.SetActive(true);
                        }
                    }
                    SetState(State.DEFEAT);
                }
            }
        }

    }



    public void SetState(State newState)
    {
        state = newState;
    }

    public void OnClickQuit()
    {
        Application.Quit();
    }

    public void OnClickLevel1()
    {
        level = 1;
        caissesramassees = 0;
        robotstues = 0;
        timer = 0;
        defeat = false;
        FPS.transform.position = originalPosition;
        FPS.SetActive(true);
        SetState(State.NIVEAU);
        elementsNiveau1.SetActive(true);
        foreach (GameObject crate in CratesList)
        {
            crate.SetActive(true);
        }
        robotLogo.SetActive(false);
        RobotsList[2].SetActive(false);
        crateLogo.SetActive(true);
        sciFiHandGun.SetActive(false);
    }

    public void OnClickLevel2()
    {
        level = 2;
        caissesramassees = 0;
        robotstues = 0;
        timer = 0;
        defeat = false;
        FPS.transform.position = originalPosition;
        FPS.SetActive(true);
        SetState(State.NIVEAU);
        foreach (GameObject robot in RobotsList)
        {
            robot.SetActive(true);
        }
        elementsNiveau1.SetActive(false);
        crateLogo.SetActive(false);
        robotLogo.SetActive(true);
        sciFiHandGun.SetActive(true);
    }

    public void OnClickRules()
    {
        SetState(State.RULES);
    }

    public void OnClickCredits()
    {
        SetState(State.CREDITS);
    }
}