﻿using UnityEngine;
using UnityEngine.AI;

[RequireComponent(typeof(NavMeshAgent))]
[RequireComponent(typeof(Animator))]

public class MoveTo : MonoBehaviour
{

    public GameObject impactPrefab;
    public Transform goal;
    public Transform[] differentPos;
    Animator anim;
    NavMeshAgent agent;
    public float detecte = 1,distDetect=12.0f;
    int actuelPos;
    float timer = 0.0f;
    Vector3 originalPosition;
    public int vies;

    void Awake()
    {
        originalPosition = transform.position;
    }
    void Start()
    {
        anim = GetComponent<Animator>();
        agent = GetComponent<NavMeshAgent>();
        actuelPos = 0;
        agent.destination = differentPos[actuelPos].position;
        vies = 3;
    }

    void OnEnable()
    {
        transform.position = originalPosition;
        actuelPos = 0;
        agent.destination = differentPos[actuelPos].position;
        detecte = 1;
        vies = 3;
        GetComponent<AudioSource>().enabled = false;
    }

    void OnCollisionEnter(Collision collision)
    {
        GameObject projectile = collision.gameObject;
        if (projectile.GetComponent<IsProjectile>() != null)
        {
            vies--;
            Instantiate(impactPrefab, projectile.transform.position, Quaternion.identity);
            Destroy(projectile);
        }
        if (vies == 0)
        {
            gameObject.SetActive(false);
            detecte = 1;
            StateMachine.instance.robotstues++;
        }

    }


    void Update()
    {
        if (Vector3.Distance(transform.position,goal.transform.position)<distDetect)
        {
            if (Time.time > timer + 1.0f)
            {
                if (Vector3.Distance(transform.position, goal.transform.position) < 4.0f)
                {
                    anim.SetTrigger("attack");
                    timer = Time.time;
                    agent.destination = goal.transform.position;
                    detecte = 0;
                }
                else
                {
                    agent.destination = goal.transform.position;
                    detecte = 2;
                }
            }
        }
        else if (Vector3.Distance(transform.position, goal.transform.position) < distDetect+2.0f)
        {
            agent.destination = differentPos[actuelPos].position;
            detecte = 1;
        }
        if (Mathf.Abs(transform.position.x - differentPos[actuelPos].position.x)<1 && Mathf.Abs(transform.position.z - differentPos[actuelPos].position.z)<1)
        {
            if (actuelPos < differentPos.Length - 1)
            {
                actuelPos++;
            }
            else
            {
                actuelPos = 0;
            }
            agent.destination = differentPos[actuelPos].position;
            
        }
        switch(detecte)
        {
            case 2:
                {
                    agent.speed = 8;
                    agent.angularSpeed=360;
                    GetComponent<AudioSource>().enabled = true;
                    goal.GetComponent<AudioSource>().volume = 0.5f;
                    break;
                }
            case 0:
                {
                    agent.speed = 4;
                    StateMachine.instance.defeat = true;
                    GetComponent<AudioSource>().enabled = false;
                    goal.GetComponent<AudioSource>().volume = 1f;
                    break;
                }
            default:
                {
                    agent.speed = 4;
                    agent.angularSpeed = 200;
                    GetComponent<AudioSource>().enabled = false;
                    goal.GetComponent<AudioSource>().volume = 1f;
                    break;
                }
        }

        anim.SetBool("move", agent.speed>1);
        anim.SetFloat("speed", agent.speed);

    }
}
