﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public enum State
{
    MENU,
    CHOIXPERSO,
    LEVEL01,
    CREDITS,
}

public class MachineEtat : MonoBehaviour
{
    public State state;
    public GameObject guiMenu;
    public GameObject guiChoixPerso;
    public GameObject guiLevel01;
    public GameObject guiCredits;
    static public MachineEtat instance;  //singleton
    public GameObject background;

    public GenerateurPlateformes gen;
    bool GenererPlateformes = false;

    void Start()
    {
        state = State.MENU;
        background.SetActive(false);
    }

    // Update is called once per frame
    void Update()
    {
        guiMenu.SetActive(state == State.MENU);
        guiChoixPerso.SetActive(state == State.CHOIXPERSO);
        guiLevel01.SetActive(state == State.LEVEL01);
        guiCredits.SetActive(state == State.CREDITS);

        if (GenererPlateformes == true)
        {
            gen.GenererPlateformes();
            GenererPlateformes = false;
        }
    }

    public void SetState(State newState)
    {
        state = newState;
    }

    public void OnClickChoix()
    {
        SetState(State.CHOIXPERSO);
    }

    public void OnClickPlay()
    {
        SetState(State.LEVEL01);
        GenererPlateformes = true;
        background.SetActive(true);
    }

    public void OnClickMenu()
    {
        SetState(State.MENU);
    }

    public void OnClickQuit()
    {
        Debug.Log("QUIT");
        Application.Quit();
    }

    public void OnClickCredit()
    {
        SetState(State.CREDITS);
    }
}
