﻿using UnityEngine;

public class Ennemy : MonoBehaviour
{
    #region Variables
    GameObject target;
    
    Transform denEnnemy;
    GameObject myEnnemy;

    public AudioClip audioCatHit;
    public AudioClip audioPigeonHit;
    public AudioSource audioSource;

    StateMachine stateMachine;

    bool isStealing = false;
    bool isDead = false;
    #endregion

    #region Base Functions
    // Use this for initialization
    void Start()
    {
        myEnnemy = this.gameObject;
        target = GameObject.FindGameObjectWithTag("Player");

        denEnnemy = GameObject.Find("DenEnnemyPosition").transform;
    }

    void Awake() {
        stateMachine = StateMachine.instance;
    }

    // Update is called once per frame
    void Update()
    {
        //IF THERE IS A NUT ON THE FLORE
        if(stateMachine.fallingNuts != null)
        {
            float distanceFallingNut = Vector3.Distance(myEnnemy.transform.position, stateMachine.fallingNuts.transform.position);
            if (distanceFallingNut <= 5.0f)
                target = stateMachine.fallingNuts;
        }
        else
        {
            target = GameObject.FindGameObjectWithTag("Player");
        }       

        //DISTANCE BETWEEN THE ENNEMY AND THE TARGET (NUT OR PLAYER)
        float distance = Vector3.Distance(myEnnemy.transform.position, target.transform.position);
        if (distance <= 1.0f)
            isStealing = true;

          

        if (isStealing == true)
        {
            Steal();            
        }
        else
        {
            Move();
        }

        if (isDead == true)
        {
            Died();
        }           
    }
    #endregion

    #region Functions
    //THE ENNEMY IS MOVING TO OAK NUTS
    private void Move()
    {
        if (target != null)
        {
            Vector3 direction = (myEnnemy.transform.position - target.transform.position).normalized;
            if (myEnnemy.tag == "Cat")
            {
                direction.y = 0;
            }

            transform.Translate(-direction * 2.5f * Time.deltaTime, Space.World);
        }
    }

    //THE ENNEMY STEAL THE OAK NUTS AND RUN AWAY
    private void Steal()
    {
        if (transform.childCount == 1)
        {
            if (transform.GetComponentInChildren<Transform>().tag != "Nuts" && isDead == false)
            {
                GameObject go;
                go = Instantiate(stateMachine.NutPrefab, transform.position + new Vector3(0, 1, 0), Quaternion.Euler(-90, 0, 0)) as GameObject;
                go.transform.parent = this.transform;

                if (target.tag == "Player")
                    stateMachine.nbHealth -= 1;
                if(target.tag == "Nuts")
                    Destroy(stateMachine.fallingNuts.gameObject);               
            }
        }

        Vector3 direction = (myEnnemy.transform.position - denEnnemy.position).normalized;
        if (myEnnemy.tag == "Cat")
            direction.y = 0;       

        transform.Translate(-direction * 2.5f * Time.deltaTime, Space.World);
    }

    //THE ENNEMY FALL AND EXPLODE
    private void Died()
    {
        if (myEnnemy.tag == "Pigeon")
        {
            GetComponent<Rigidbody>().useGravity = true;
        }

        if (transform.childCount == 2)
        {
            transform.GetChild(1).GetComponent<Rigidbody>().isKinematic = false;
            stateMachine.fallingNuts = transform.GetChild(1).gameObject;
            transform.GetChild(1).parent = null;
        }

        transform.localScale *= 1.005f;
        Destroy(this.gameObject, 1.0f);
    }

    //THE ENNEMY DIED WHEN HIT BY A BULLET OR IS DESTROY WHEN ARRIVED AT THE DEN
    private void OnCollisionEnter(Collision collision)
    {
        if (collision.gameObject.tag == "Bullet") {
            if (myEnnemy.tag == "Cat") 
                audioSource.clip = audioCatHit;
            
            else if(myEnnemy.tag == "Pigeon") 
                audioSource.clip = audioPigeonHit;
            
            audioSource.Play();
            isDead = true;
        }            
        
        if (collision.gameObject.tag == "Den")
            Destroy(this.gameObject);
    }
    #endregion
}
