﻿using UnityEngine;
using UnityEngine.EventSystems;

public class CameraRotation : MonoBehaviour, IPointerEnterHandler, IPointerExitHandler
{
    #region Variables
    public Camera myCamera;
    private bool isOver = false;
    #endregion

    #region Base Functions
    public void Update()
    {
        if (isOver == true)
        {
            if (gameObject.name == "LeftSide" && myCamera.transform.rotation.y > -0.38f)
            {
                myCamera.transform.Rotate(0, -50f * Time.deltaTime, 0, Space.World);
            }
            else if (gameObject.name == "RightSide" && myCamera.transform.rotation.y < 0.38f)
            {
                myCamera.transform.Rotate(0, 50f * Time.deltaTime, 0, Space.World);
            }            
            else if (gameObject.name == "UpSide" && myCamera.transform.rotation.x > -0.1f)
            {
                myCamera.transform.Rotate(-20f * Time.deltaTime, 0, 0, Space.Self);
            }
            else if (gameObject.name == "DownSide" && myCamera.transform.rotation.x < 0f)
            {
                myCamera.transform.Rotate(30f * Time.deltaTime, 0, 0, Space.Self);
            }            
        }
    }
    #endregion

    #region Function Hover
    //Detect if the Cursor starts to pass over the GameObject
    public void OnPointerEnter(PointerEventData pointerEventData)
    {
        isOver = true;
    }

    //Detect when Cursor leaves the GameObject
    public void OnPointerExit(PointerEventData pointerEventData)
    {
        isOver = false;
    }
    #endregion        
}