﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;


    public enum State
    {
        MENU,
        LVL1,
        HOWTOPLAY,
        //LVL2,
        //LVL3,
        WIN,
        CREDIT       
    }

public class StateMachine : MonoBehaviour
{
    static public StateMachine instance;  //singleton

    public State state;
    public GameObject guiMenu;
    public GameObject Lvl1;
    //public GameObject Lvl2;
    //public GameObject Lvl3;
    public GameObject guiCredit;
    public GameObject guiHowToPlay;

    public GameObject guiWIN;
    public GameObject guiWIN_P1;
    public GameObject guiWIN_P2;

    public GameObject player1Ragdoll;
    public GameObject player2Ragdoll;

    GameObject victoireJ1;
    GameObject victoireJ2;



    void Awake()
    {
        if (instance != null) Debug.LogError("Double singleton!");
        instance = this;

        guiMenu.SetActive(false);
        Lvl1.SetActive(false);
        //Lvl2.SetActive(false);
        //Lvl3.SetActive(false);
        guiCredit.SetActive(false);
        guiWIN.SetActive(false);
        guiHowToPlay.SetActive(false);
    }

    void Start()
    {
        state = State.MENU;
    }

    void Update()
    {
        guiMenu.SetActive(state == State.MENU);
        Lvl1.SetActive(state == State.LVL1);
        guiCredit.SetActive(state == State.CREDIT);
        guiHowToPlay.SetActive(state == State.HOWTOPLAY);
        guiWIN.SetActive(state == State.WIN);


    }
    public void OnClickButtonPlay()
    {
        state = State.LVL1;
    }

    public void OnClicButtonCredit()
    {
        state = State.CREDIT;
    }

    public void OnClickButtonHowToPlay()
    {
        state = State.HOWTOPLAY;
    }

    public void OnClickButtonGoToMenu()
    {
        state = State.MENU;
        
    }
    public void activeWinScreen(bool player)
    {
        state = State.WIN;

        if(player)
            guiWIN_P2.SetActive(true);

        else
            guiWIN_P1.SetActive(true);
    }
}





